/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.matching;

import java.util.Collections;
import java.util.Set;
import org.streampipes.manager.matching.FormatSelector;
import org.streampipes.manager.matching.ProtocolSelector;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.grounding.EventGrounding;
import org.streampipes.model.grounding.TransportFormat;
import org.streampipes.model.grounding.TransportProtocol;

public class GroundingBuilder {
    private NamedStreamPipesEntity source;
    private Set<InvocableStreamPipesEntity> targets;

    public GroundingBuilder(NamedStreamPipesEntity source, Set<InvocableStreamPipesEntity> targets) {
        this.source = source;
        this.targets = targets;
    }

    public EventGrounding getEventGrounding() {
        EventGrounding grounding = new EventGrounding();
        grounding.setTransportFormats(Collections.singletonList(this.getFormat()));
        grounding.setTransportProtocols(Collections.singletonList(this.getProtocol()));
        return grounding;
    }

    private TransportFormat getFormat() {
        return new FormatSelector(this.source, this.targets).getTransportFormat();
    }

    private TransportProtocol getProtocol() {
        return new ProtocolSelector(this.source, this.targets).getPreferredProtocol();
    }
}

