/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.matching;

import java.util.ArrayList;
import java.util.List;
import org.streampipes.commons.exceptions.NoSepaInPipelineException;
import org.streampipes.manager.data.PipelineGraph;
import org.streampipes.manager.data.PipelineGraphBuilder;
import org.streampipes.manager.matching.InvocationGraphBuilder;
import org.streampipes.manager.matching.v2.ElementVerification;
import org.streampipes.manager.matching.v2.mapping.MappingPropertyCalculator;
import org.streampipes.manager.selector.PropertyRequirementSelector;
import org.streampipes.manager.selector.PropertySelectorGenerator;
import org.streampipes.manager.util.PipelineVerificationUtils;
import org.streampipes.manager.util.TreeUtils;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.client.connection.Connection;
import org.streampipes.model.client.exception.InvalidConnectionException;
import org.streampipes.model.client.pipeline.Pipeline;
import org.streampipes.model.client.pipeline.PipelineModification;
import org.streampipes.model.client.pipeline.PipelineModificationMessage;
import org.streampipes.model.graph.DataProcessorInvocation;
import org.streampipes.model.output.CustomOutputStrategy;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.staticproperty.MappingProperty;
import org.streampipes.storage.management.StorageDispatcher;

public class PipelineVerificationHandler {
    private Pipeline pipeline;
    private PipelineModificationMessage pipelineModificationMessage;
    private List<InvocableStreamPipesEntity> invocationGraphs;
    private InvocableStreamPipesEntity rdfRootElement;

    public PipelineVerificationHandler(Pipeline pipeline) throws NoSepaInPipelineException {
        this.pipeline = pipeline;
        this.rdfRootElement = PipelineVerificationUtils.getRootNode(pipeline);
        this.invocationGraphs = new ArrayList<InvocableStreamPipesEntity>();
        this.pipelineModificationMessage = new PipelineModificationMessage();
    }

    public PipelineVerificationHandler validateConnection() throws InvalidConnectionException {
        ElementVerification verifier = new ElementVerification();
        boolean verified = true;
        InvocableStreamPipesEntity rightElement = this.rdfRootElement;
        List connectedTo = this.rdfRootElement.getConnectedTo();
        for (String domId : connectedTo) {
            NamedStreamPipesEntity element = TreeUtils.findSEPAElement(domId, this.pipeline.getSepas(), this.pipeline.getStreams());
            if (element instanceof SpDataStream) {
                SpDataStream leftSpDataStream = (SpDataStream)element;
                if (verifier.verify(leftSpDataStream, rightElement)) continue;
                verified = false;
                continue;
            }
            this.invocationGraphs.addAll(this.makeInvocationGraphs());
            DataProcessorInvocation ancestor = this.findInvocationGraph(this.invocationGraphs, element.getDOM());
            if (verifier.verify(ancestor, rightElement)) continue;
            verified = false;
        }
        if (!verified) {
            throw new InvalidConnectionException(verifier.getErrorLog());
        }
        return this;
    }

    public PipelineVerificationHandler computeMappingProperties() {
        List connectedTo = this.rdfRootElement.getConnectedTo();
        String domId = this.rdfRootElement.getDOM();
        ArrayList<SpDataStream> tempStreams = new ArrayList<SpDataStream>();
        for (int i = 0; i < connectedTo.size(); ++i) {
            SpDataStream incomingStream;
            NamedStreamPipesEntity element = TreeUtils.findSEPAElement((String)this.rdfRootElement.getConnectedTo().get(i), this.pipeline.getSepas(), this.pipeline.getStreams());
            if (!(element instanceof DataProcessorInvocation) && !(element instanceof SpDataStream)) continue;
            if (element instanceof DataProcessorInvocation) {
                DataProcessorInvocation ancestor = (DataProcessorInvocation)TreeUtils.findByDomId((String)connectedTo.get(i), this.invocationGraphs);
                incomingStream = ancestor.getOutputStream();
            } else {
                incomingStream = (SpDataStream)element;
            }
            tempStreams.add(incomingStream);
            if (this.rdfRootElement.getStreamRequirements().size() - 1 != i) continue;
            this.updateStaticProperties(tempStreams);
            PipelineModification modification = new PipelineModification(domId, this.rdfRootElement.getElementId(), this.rdfRootElement.getStaticProperties());
            modification.setInputStreams(tempStreams);
            this.updateOutputStrategy(tempStreams);
            if (this.rdfRootElement instanceof DataProcessorInvocation) {
                modification.setOutputStrategies(((DataProcessorInvocation)this.rdfRootElement).getOutputStrategies());
            }
            this.pipelineModificationMessage.addPipelineModification(modification);
        }
        return this;
    }

    private void updateStaticProperties(List<SpDataStream> inputStreams) {
        this.rdfRootElement.getStaticProperties().stream().filter(property -> property instanceof MappingProperty).forEach(property -> {
            MappingProperty mappingProperty = (MappingProperty)property;
            if (!mappingProperty.getRequirementSelector().equals("")) {
                mappingProperty.setMapsFromOptions(this.generateSelectorsFromRequirement(inputStreams, mappingProperty.getRequirementSelector()));
            } else {
                mappingProperty.setMapsFromOptions(this.generateSelectorsWithoutRequirement(inputStreams));
            }
        });
    }

    private List<String> generateSelectorsFromRequirement(List<SpDataStream> inputStreams, String requirementSelector) {
        PropertyRequirementSelector selector = new PropertyRequirementSelector(requirementSelector);
        EventProperty propertyRequirement = selector.findPropertyRequirement(this.rdfRootElement.getStreamRequirements());
        SpDataStream inputStream = selector.getAffectedStream(inputStreams);
        List<String> availablePropertySelectors = new PropertySelectorGenerator(inputStream.getEventSchema(), (Boolean)true).generateSelectors(selector.getAffectedStreamPrefix());
        return new MappingPropertyCalculator(inputStream.getEventSchema(), availablePropertySelectors, propertyRequirement).matchedPropertySelectors();
    }

    private List<String> generateSelectorsWithoutRequirement(List<SpDataStream> inputStreams) {
        ArrayList<String> selectors = new ArrayList<String>(new PropertySelectorGenerator(inputStreams.get(0).getEventSchema().getEventProperties(), (Boolean)true).generateSelectors("s0"));
        if (inputStreams.size() > 1) {
            selectors.addAll(new PropertySelectorGenerator(inputStreams.get(1).getEventSchema().getEventProperties(), (Boolean)true).generateSelectors("s1"));
        }
        return selectors;
    }

    private void updateOutputStrategy(List<SpDataStream> inputStreams) {
        if (this.rdfRootElement instanceof DataProcessorInvocation) {
            ((DataProcessorInvocation)this.rdfRootElement).getOutputStrategies().stream().filter(strategy -> strategy instanceof CustomOutputStrategy).forEach(strategy -> {
                CustomOutputStrategy outputStrategy = (CustomOutputStrategy)strategy;
                if (inputStreams.size() == 1 || inputStreams.size() > 1 && !outputStrategy.isOutputRight()) {
                    outputStrategy.setAvailablePropertyKeys(new PropertySelectorGenerator(((SpDataStream)inputStreams.get(0)).getEventSchema(), (Boolean)false).generateSelectors());
                } else {
                    outputStrategy.setAvailablePropertyKeys(new PropertySelectorGenerator(((SpDataStream)inputStreams.get(0)).getEventSchema(), ((SpDataStream)inputStreams.get(1)).getEventSchema(), false).generateSelectors());
                }
            });
        }
    }

    public PipelineVerificationHandler storeConnection() {
        String fromId = (String)this.rdfRootElement.getConnectedTo().get(this.rdfRootElement.getConnectedTo().size() - 1);
        NamedStreamPipesEntity sepaElement = TreeUtils.findSEPAElement(fromId, this.pipeline.getSepas(), this.pipeline.getStreams());
        String sourceId = sepaElement instanceof SpDataStream ? sepaElement.getElementId() : ((InvocableStreamPipesEntity)sepaElement).getBelongsTo();
        Connection connection = new Connection(sourceId, this.rdfRootElement.getBelongsTo());
        StorageDispatcher.INSTANCE.getNoSqlStore().getConnectionStorageApi().addConnection(connection);
        return this;
    }

    public PipelineModificationMessage getPipelineModificationMessage() {
        return this.pipelineModificationMessage;
    }

    public List<InvocableStreamPipesEntity> makeInvocationGraphs() {
        PipelineGraph pipelineGraph = new PipelineGraphBuilder(this.pipeline).buildGraph();
        return new InvocationGraphBuilder(pipelineGraph, null).buildGraphs();
    }

    private DataProcessorInvocation findInvocationGraph(List<InvocableStreamPipesEntity> graphs, String domId) {
        return (DataProcessorInvocation)TreeUtils.findByDomId(domId, graphs);
    }
}

