/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.matching;

import java.util.List;
import java.util.Set;
import org.streampipes.config.backend.BackendConfig;
import org.streampipes.manager.matching.GroundingSelector;
import org.streampipes.manager.util.TopicGenerator;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.grounding.JmsTransportProtocol;
import org.streampipes.model.grounding.KafkaTransportProtocol;
import org.streampipes.model.grounding.TransportProtocol;

public class ProtocolSelector
extends GroundingSelector {
    private String outputTopic = TopicGenerator.generateRandomTopic();

    public ProtocolSelector(NamedStreamPipesEntity source, Set<InvocableStreamPipesEntity> targets) {
        super(source, targets);
    }

    public TransportProtocol getPreferredProtocol() {
        if (this.source instanceof SpDataStream) {
            return ((SpDataStream)this.source).getEventGrounding().getTransportProtocol();
        }
        if (this.supportsProtocol(KafkaTransportProtocol.class)) {
            return this.kafkaTopic();
        }
        if (this.supportsProtocol(JmsTransportProtocol.class)) {
            return new JmsTransportProtocol(BackendConfig.INSTANCE.getJmsHost(), BackendConfig.INSTANCE.getJmsPort(), this.outputTopic);
        }
        return this.kafkaTopic();
    }

    private TransportProtocol kafkaTopic() {
        return new KafkaTransportProtocol(BackendConfig.INSTANCE.getKafkaHost(), BackendConfig.INSTANCE.getKafkaPort(), this.outputTopic, BackendConfig.INSTANCE.getZookeeperHost(), BackendConfig.INSTANCE.getZookeeperPort());
    }

    public <T extends TransportProtocol> boolean supportsProtocol(Class<T> protocol) {
        List<InvocableStreamPipesEntity> elements = this.buildInvocables();
        return elements.stream().allMatch(e -> e.getSupportedGrounding().getTransportProtocols().stream().anyMatch(p -> protocol.isInstance(p)));
    }
}

