/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.matching.output;

import java.util.List;
import org.streampipes.manager.matching.output.OutputSchemaGenerator;
import org.streampipes.manager.selector.PropertySelector;
import org.streampipes.manager.selector.PropertySelectorGenerator;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.output.AppendOutputStrategy;
import org.streampipes.model.output.OutputStrategy;
import org.streampipes.model.output.PropertyRenameRule;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventSchema;
import org.streampipes.sdk.helpers.Tuple2;

public class AppendOutputSchemaGenerator
extends OutputSchemaGenerator<AppendOutputStrategy> {
    private List<EventProperty> appendProperties;

    public static AppendOutputSchemaGenerator from(OutputStrategy strategy) {
        return new AppendOutputSchemaGenerator((AppendOutputStrategy)strategy);
    }

    public AppendOutputSchemaGenerator(AppendOutputStrategy strategy) {
        super(strategy);
        this.appendProperties = strategy.getEventProperties();
    }

    @Override
    public Tuple2<EventSchema, AppendOutputStrategy> buildFromOneStream(SpDataStream stream) {
        List<String> selectors = new PropertySelectorGenerator(stream.getEventSchema(), (Boolean)true).generateSelectors();
        Tuple2<List<EventProperty>, List<PropertyRenameRule>> generatedOutputProperties = new PropertySelector(stream.getEventSchema()).createRenamedPropertyList(selectors, this.appendProperties);
        EventSchema outputSchema = new EventSchema((List)generatedOutputProperties.a);
        return new Tuple2((Object)outputSchema, (Object)this.getModifiedOutputStrategy((List)generatedOutputProperties.b));
    }

    @Override
    public Tuple2<EventSchema, AppendOutputStrategy> buildFromTwoStreams(SpDataStream stream1, SpDataStream stream2) {
        List<String> selectors = new PropertySelectorGenerator(stream1.getEventSchema(), stream2.getEventSchema(), true).generateSelectors();
        Tuple2<List<EventProperty>, List<PropertyRenameRule>> generatedOutputProperties = new PropertySelector(stream1.getEventSchema(), stream2.getEventSchema()).createRenamedPropertyList(selectors, this.appendProperties);
        EventSchema outputSchema = new EventSchema((List)generatedOutputProperties.a);
        return new Tuple2((Object)outputSchema, (Object)this.getModifiedOutputStrategy((List)generatedOutputProperties.b));
    }

    private AppendOutputStrategy getModifiedOutputStrategy(List<PropertyRenameRule> propertyRenameRules) {
        ((AppendOutputStrategy)this.outputStrategy).setRenameRules(propertyRenameRules);
        return (AppendOutputStrategy)this.outputStrategy;
    }
}

