/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.matching.output;

import java.util.List;
import org.streampipes.manager.matching.output.OutputSchemaGenerator;
import org.streampipes.manager.selector.PropertySelector;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.output.CustomOutputStrategy;
import org.streampipes.model.output.OutputStrategy;
import org.streampipes.model.output.PropertyRenameRule;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventSchema;
import org.streampipes.sdk.helpers.Tuple2;

public class CustomOutputSchemaGenerator
extends OutputSchemaGenerator<CustomOutputStrategy> {
    private List<String> selectedPropertyKeys;

    public static CustomOutputSchemaGenerator from(OutputStrategy strategy) {
        return new CustomOutputSchemaGenerator((CustomOutputStrategy)strategy);
    }

    public CustomOutputSchemaGenerator(CustomOutputStrategy strategy) {
        super(strategy);
        this.selectedPropertyKeys = strategy.getSelectedPropertyKeys();
    }

    @Override
    public Tuple2<EventSchema, CustomOutputStrategy> buildFromOneStream(SpDataStream stream) {
        return new Tuple2((Object)new EventSchema(new PropertySelector(stream.getEventSchema()).createPropertyList(this.selectedPropertyKeys)), (Object)this.outputStrategy);
    }

    @Override
    public Tuple2<EventSchema, CustomOutputStrategy> buildFromTwoStreams(SpDataStream stream1, SpDataStream stream2) {
        Tuple2<List<EventProperty>, List<PropertyRenameRule>> generatedOutputProperties = new PropertySelector(stream1.getEventSchema(), stream2.getEventSchema()).createRenamedPropertyList(this.selectedPropertyKeys);
        EventSchema outputSchema = new EventSchema((List)generatedOutputProperties.a);
        return new Tuple2((Object)outputSchema, (Object)this.getModifiedOutputStrategy((List)generatedOutputProperties.b));
    }

    private CustomOutputStrategy getModifiedOutputStrategy(List<PropertyRenameRule> propertyRenameRules) {
        ((CustomOutputStrategy)this.outputStrategy).setRenameRules(propertyRenameRules);
        return (CustomOutputStrategy)this.outputStrategy;
    }
}

