/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.matching.output;

import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.streampipes.manager.matching.output.OutputSchemaGenerator;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.graph.DataProcessorInvocation;
import org.streampipes.model.output.CustomTransformOutputStrategy;
import org.streampipes.model.output.OutputStrategy;
import org.streampipes.model.schema.EventSchema;
import org.streampipes.sdk.helpers.Tuple2;
import org.streampipes.serializers.json.GsonSerializer;

public class CustomTransformOutputSchemaGenerator
extends OutputSchemaGenerator<CustomTransformOutputStrategy> {
    private DataProcessorInvocation dataProcessorInvocation;
    private CustomTransformOutputStrategy outputStrategy;

    public static CustomTransformOutputSchemaGenerator from(OutputStrategy strategy, DataProcessorInvocation invocation) {
        return new CustomTransformOutputSchemaGenerator((CustomTransformOutputStrategy)strategy, invocation);
    }

    public CustomTransformOutputSchemaGenerator(CustomTransformOutputStrategy strategy, DataProcessorInvocation invocation) {
        super(strategy);
        this.dataProcessorInvocation = invocation;
    }

    @Override
    public Tuple2<EventSchema, CustomTransformOutputStrategy> buildFromOneStream(SpDataStream stream) {
        return this.makeTuple(this.makeRequest());
    }

    @Override
    public Tuple2<EventSchema, CustomTransformOutputStrategy> buildFromTwoStreams(SpDataStream stream1, SpDataStream stream2) {
        return this.makeTuple(this.makeRequest());
    }

    private EventSchema makeRequest() {
        String httpRequestBody = GsonSerializer.getGsonWithIds().toJson((Object)this.dataProcessorInvocation);
        try {
            Response httpResp = Request.Post((String)(this.dataProcessorInvocation.getBelongsTo() + "/output")).bodyString(httpRequestBody, ContentType.APPLICATION_JSON).execute();
            return this.handleResponse(httpResp);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new EventSchema();
        }
    }

    private EventSchema handleResponse(Response httpResp) throws JsonSyntaxException, IOException {
        String resp = httpResp.returnContent().asString();
        EventSchema outputSchema = (EventSchema)GsonSerializer.getGsonWithIds().fromJson(resp, EventSchema.class);
        return outputSchema;
    }
}

