/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.matching.output;

import java.net.URI;
import java.util.List;
import org.streampipes.commons.Utils;
import org.streampipes.empire.core.empire.SupportsRdfId;
import org.streampipes.manager.matching.output.OutputSchemaGenerator;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.output.ListOutputStrategy;
import org.streampipes.model.output.OutputStrategy;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventPropertyList;
import org.streampipes.model.schema.EventSchema;
import org.streampipes.sdk.helpers.Tuple2;

public class ListOutputSchemaGenerator
extends OutputSchemaGenerator<ListOutputStrategy> {
    private String propertyName;

    public static ListOutputSchemaGenerator from(OutputStrategy strategy) {
        return new ListOutputSchemaGenerator((ListOutputStrategy)strategy);
    }

    public ListOutputSchemaGenerator(ListOutputStrategy strategy) {
        super(strategy);
        this.propertyName = strategy.getPropertyName();
    }

    @Override
    public Tuple2<EventSchema, ListOutputStrategy> buildFromOneStream(SpDataStream stream) {
        return this.makeTuple(this.makeList(stream.getEventSchema().getEventProperties()));
    }

    @Override
    public Tuple2<EventSchema, ListOutputStrategy> buildFromTwoStreams(SpDataStream stream1, SpDataStream stream2) {
        return this.buildFromOneStream(stream1);
    }

    private EventSchema makeList(List<EventProperty> schemaProperties) {
        EventPropertyList list = new EventPropertyList();
        list.setRuntimeName(this.propertyName);
        list.setRdfId((SupportsRdfId.RdfKey)new SupportsRdfId.URIKey(URI.create(schemaProperties.get(0).getRdfId() + "-list")));
        EventSchema schema = new EventSchema();
        schema.setEventProperties(Utils.createList((Object[])new EventProperty[]{list}));
        return schema;
    }
}

