/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.matching.output;

import org.streampipes.manager.matching.output.AppendOutputSchemaGenerator;
import org.streampipes.manager.matching.output.CustomOutputSchemaGenerator;
import org.streampipes.manager.matching.output.CustomTransformOutputSchemaGenerator;
import org.streampipes.manager.matching.output.FixedOutputSchemaGenerator;
import org.streampipes.manager.matching.output.ListOutputSchemaGenerator;
import org.streampipes.manager.matching.output.OutputSchemaGenerator;
import org.streampipes.manager.matching.output.RenameOutputSchemaGenerator;
import org.streampipes.manager.matching.output.TransformOutputSchemaGenerator;
import org.streampipes.model.graph.DataProcessorInvocation;
import org.streampipes.model.output.AppendOutputStrategy;
import org.streampipes.model.output.CustomOutputStrategy;
import org.streampipes.model.output.CustomTransformOutputStrategy;
import org.streampipes.model.output.FixedOutputStrategy;
import org.streampipes.model.output.KeepOutputStrategy;
import org.streampipes.model.output.ListOutputStrategy;
import org.streampipes.model.output.OutputStrategy;
import org.streampipes.model.output.TransformOutputStrategy;

public class OutputSchemaFactory {
    private OutputStrategy outputStrategy;
    private DataProcessorInvocation dataProcessorInvocation;

    public OutputSchemaFactory(DataProcessorInvocation dataProcessorInvocation) {
        this.dataProcessorInvocation = dataProcessorInvocation;
        this.outputStrategy = (OutputStrategy)dataProcessorInvocation.getOutputStrategies().get(0);
    }

    public OutputSchemaGenerator<?> getOuputSchemaGenerator() {
        if (this.outputStrategy instanceof AppendOutputStrategy) {
            return AppendOutputSchemaGenerator.from(this.outputStrategy);
        }
        if (this.outputStrategy instanceof KeepOutputStrategy) {
            return RenameOutputSchemaGenerator.from(this.outputStrategy);
        }
        if (this.outputStrategy instanceof FixedOutputStrategy) {
            return FixedOutputSchemaGenerator.from(this.outputStrategy);
        }
        if (this.outputStrategy instanceof CustomOutputStrategy) {
            return CustomOutputSchemaGenerator.from(this.outputStrategy);
        }
        if (this.outputStrategy instanceof ListOutputStrategy) {
            return ListOutputSchemaGenerator.from(this.outputStrategy);
        }
        if (this.outputStrategy instanceof TransformOutputStrategy) {
            return TransformOutputSchemaGenerator.from(this.outputStrategy, this.dataProcessorInvocation);
        }
        if (this.outputStrategy instanceof CustomTransformOutputStrategy) {
            return CustomTransformOutputSchemaGenerator.from(this.outputStrategy, this.dataProcessorInvocation);
        }
        throw new IllegalArgumentException();
    }
}

