/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.matching.output;

import java.util.ArrayList;
import org.streampipes.manager.matching.output.OutputSchemaGenerator;
import org.streampipes.manager.matching.output.PropertyDuplicateRemover;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.output.KeepOutputStrategy;
import org.streampipes.model.output.OutputStrategy;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventSchema;
import org.streampipes.sdk.helpers.Tuple2;

public class RenameOutputSchemaGenerator
extends OutputSchemaGenerator<KeepOutputStrategy> {
    public static RenameOutputSchemaGenerator from(OutputStrategy strategy) {
        return new RenameOutputSchemaGenerator((KeepOutputStrategy)strategy);
    }

    public RenameOutputSchemaGenerator(KeepOutputStrategy strategy) {
        super(strategy);
    }

    @Override
    public Tuple2<EventSchema, KeepOutputStrategy> buildFromOneStream(SpDataStream stream) {
        return this.makeTuple(stream.getEventSchema());
    }

    @Override
    public Tuple2<EventSchema, KeepOutputStrategy> buildFromTwoStreams(SpDataStream stream1, SpDataStream stream2) {
        EventSchema resultSchema = new EventSchema();
        ArrayList<EventProperty> properties = new ArrayList<EventProperty>();
        properties.addAll(stream1.getEventSchema().getEventProperties());
        if (((KeepOutputStrategy)this.outputStrategy).isKeepBoth()) {
            properties.addAll(new PropertyDuplicateRemover(properties, stream2.getEventSchema().getEventProperties()).rename());
        }
        resultSchema.setEventProperties(properties);
        return this.makeTuple(resultSchema);
    }
}

