/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.matching.v2;

import java.util.List;
import org.streampipes.manager.matching.v2.AbstractMatcher;
import org.streampipes.manager.matching.v2.ListPropertyMatch;
import org.streampipes.manager.matching.v2.NestedPropertyMatch;
import org.streampipes.manager.matching.v2.PrimitivePropertyMatch;
import org.streampipes.model.client.matching.MatchingResultMessage;
import org.streampipes.model.client.matching.MatchingResultType;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventPropertyList;
import org.streampipes.model.schema.EventPropertyNested;
import org.streampipes.model.schema.EventPropertyPrimitive;

public class PropertyMatch
extends AbstractMatcher<EventProperty, EventProperty> {
    public PropertyMatch() {
        super(MatchingResultType.PROPERTY_MATCH);
    }

    @Override
    public boolean match(EventProperty offer, EventProperty requirement, List<MatchingResultMessage> errorLog) {
        if (this.isAnyProperty(requirement)) {
            return true;
        }
        if (!this.matchesType(offer, requirement)) {
            this.buildErrorMessage(errorLog, "The required type " + requirement.getClass().getSimpleName() + " is not present in the connected stream.");
            return false;
        }
        if (this.isPrimitive(requirement)) {
            return new PrimitivePropertyMatch().match(this.toPrimitive(offer), this.toPrimitive(requirement), errorLog);
        }
        if (this.isList(requirement)) {
            return new ListPropertyMatch().match(this.toList(offer), this.toList(requirement), errorLog);
        }
        if (this.isNested(requirement)) {
            return new NestedPropertyMatch().match(this.toNested(offer), this.toNested(requirement), errorLog);
        }
        return false;
    }

    private boolean isAnyProperty(EventProperty eventProperty) {
        return eventProperty instanceof EventPropertyPrimitive && eventProperty.getDomainProperties() == null && ((EventPropertyPrimitive)eventProperty).getMeasurementUnit() == null && ((EventPropertyPrimitive)eventProperty).getRuntimeType() == null;
    }

    private EventPropertyNested toNested(EventProperty property) {
        return (EventPropertyNested)property;
    }

    private EventPropertyList toList(EventProperty property) {
        return (EventPropertyList)property;
    }

    private EventPropertyPrimitive toPrimitive(EventProperty property) {
        return (EventPropertyPrimitive)property;
    }

    private boolean isList(EventProperty requirement) {
        return requirement instanceof EventPropertyList;
    }

    private boolean isNested(EventProperty requirement) {
        return requirement instanceof EventPropertyNested;
    }

    private boolean isPrimitive(EventProperty requirement) {
        return requirement instanceof EventPropertyPrimitive;
    }

    public boolean matchesType(EventProperty offer, EventProperty requirement) {
        return offer.getClass().getCanonicalName().equals(requirement.getClass().getCanonicalName());
    }
}

