/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.matching.v2.mapping;

import java.util.ArrayList;
import java.util.List;
import org.streampipes.manager.matching.v2.PropertyMatch;
import org.streampipes.manager.selector.PropertyFinder;
import org.streampipes.model.client.matching.MatchingResultMessage;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventSchema;

public class MappingPropertyCalculator {
    private EventSchema schema;
    private List<String> availablePropertySelectors;
    private EventProperty requirement;

    public MappingPropertyCalculator() {
    }

    public MappingPropertyCalculator(EventSchema schema, List<String> availablePropertySelectors, EventProperty requirement) {
        this.schema = schema;
        this.availablePropertySelectors = availablePropertySelectors;
        this.requirement = requirement;
    }

    public List<String> matchedPropertySelectors() {
        ArrayList<String> matchedSelectors = new ArrayList<String>();
        for (String propertySelector : this.availablePropertySelectors) {
            List<EventProperty> offeredProperties = this.getEventProperty(propertySelector);
            if (offeredProperties.size() != 1 || !new PropertyMatch().match(offeredProperties.get(0), this.requirement, (List<MatchingResultMessage>)new ArrayList<MatchingResultMessage>())) continue;
            matchedSelectors.add(propertySelector);
        }
        return matchedSelectors;
    }

    private List<EventProperty> getEventProperty(String propertySelector) {
        return new PropertyFinder(this.schema, propertySelector).findProperty();
    }
}

