/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.monitoring.job;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.streampipes.manager.monitoring.job.MonitoringJob;
import org.streampipes.manager.monitoring.job.MonitoringJobExecutor;
import org.streampipes.manager.monitoring.job.SecMonitoringJob;
import org.streampipes.manager.monitoring.job.SepaMonitoringJob;
import org.streampipes.model.graph.DataProcessorDescription;
import org.streampipes.model.graph.DataSinkDescription;
import org.streampipes.storage.management.StorageManager;

public enum JobManager {
    INSTANCE;

    private List<MonitoringJob<?>> currentJobs = new ArrayList();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);

    public void addJob(MonitoringJob<?> job) {
        this.currentJobs.add(job);
        this.scheduler.scheduleAtFixedRate(new MonitoringJobExecutor(job), 10L, 10L, TimeUnit.MINUTES);
    }

    public void removeJob(MonitoringJob<?> job) {
        this.currentJobs.remove(job);
    }

    public List<MonitoringJob<?>> getCurrentJobs() {
        return this.currentJobs;
    }

    public void prepareMonitoring() {
        StorageManager.INSTANCE.getStorageAPI().getAllSEPAs().forEach(s -> this.addJob(new SepaMonitoringJob((DataProcessorDescription)s)));
        StorageManager.INSTANCE.getStorageAPI().getAllSECs().forEach(s -> this.addJob(new SecMonitoringJob((DataSinkDescription)s)));
    }
}

