/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.monitoring.job;

import java.util.ArrayList;
import java.util.List;
import org.streampipes.manager.monitoring.task.GetDescriptionTask;
import org.streampipes.manager.monitoring.task.TaskDefinition;
import org.streampipes.model.base.ConsumableStreamPipesEntity;
import org.streampipes.model.client.monitoring.TaskReport;

public abstract class MonitoringJob<T extends ConsumableStreamPipesEntity> {
    protected T monitoredObject;
    protected List<TaskDefinition> tasks;
    protected long repeatAfter;
    protected boolean success;
    protected String elementId;

    public MonitoringJob(T monitoredObject, long repeatAfter) {
        this.monitoredObject = monitoredObject;
        this.tasks = new ArrayList<TaskDefinition>();
        this.repeatAfter = repeatAfter;
        this.elementId = monitoredObject.getUri();
    }

    public MonitoringJob(T monitoredObject) {
        this.monitoredObject = monitoredObject;
        this.tasks = new ArrayList<TaskDefinition>();
        this.repeatAfter = 6000L;
    }

    protected void getDefinedTasks() {
        this.tasks.add(new GetDescriptionTask((ConsumableStreamPipesEntity)this.monitoredObject));
    }

    public String getElementId() {
        return this.elementId;
    }

    public List<TaskReport> performJobExecution() {
        this.getDefinedTasks();
        ArrayList<TaskReport> reports = new ArrayList<TaskReport>();
        this.tasks.forEach(t -> reports.add(t.execute()));
        this.success = reports.stream().anyMatch(r -> !r.isSuccess());
        return reports;
    }

    public boolean isJobExecutionSuccessful() {
        return this.success;
    }

    protected abstract void generateInvocableSepaElement();
}

