/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.monitoring.runtime;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.streampipes.manager.monitoring.job.MonitoringUtils;
import org.streampipes.manager.monitoring.runtime.FormatGenerator;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventPropertyList;
import org.streampipes.model.schema.EventPropertyNested;
import org.streampipes.model.schema.EventPropertyPrimitive;
import org.streampipes.model.schema.EventSchema;

public abstract class EventGenerator {
    protected EventSchema schema;
    private FormatGenerator formatGenerator;

    public EventGenerator(EventSchema schema, FormatGenerator formatGenerator) {
        this.schema = schema;
        this.formatGenerator = formatGenerator;
    }

    public Object nextEvent() {
        return this.formatGenerator.makeOutputFormat(this.makeEvent(new HashMap<String, Object>(), this.schema.getEventProperties()));
    }

    protected Map<String, Object> makeEvent(Map<String, Object> map, List<EventProperty> properties) {
        for (EventProperty p : properties) {
            if (p instanceof EventPropertyPrimitive) {
                map.put(this.randomKey(), this.makePrimitiveProperty((EventPropertyPrimitive)p));
                continue;
            }
            if (p instanceof EventPropertyNested) {
                map.put(this.randomKey(), this.makeNestedProperty((EventPropertyNested)p));
                continue;
            }
            if (p instanceof EventPropertyList) {
                map.put(this.randomKey(), this.makeListProperty((EventPropertyList)p));
                continue;
            }
            throw new IllegalArgumentException("Wrong type detected");
        }
        return map;
    }

    private String randomKey() {
        return MonitoringUtils.randomKey();
    }

    protected abstract Map<String, Object> makeNestedProperty(EventPropertyNested var1);

    protected abstract Object makePrimitiveProperty(EventPropertyPrimitive var1);

    protected abstract List<?> makeListProperty(EventPropertyList var1);
}

