/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.monitoring.runtime;

import org.streampipes.manager.execution.status.PipelineStatusManager;
import org.streampipes.manager.monitoring.runtime.PipelineStreamReplacer;
import org.streampipes.manager.monitoring.runtime.SimilarStreamFinder;
import org.streampipes.model.client.pipeline.PipelineStatusMessage;
import org.streampipes.model.client.pipeline.PipelineStatusMessageType;

public class PipelineObserver {
    private String pipelineId;

    public PipelineObserver(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public void update() {
        System.out.println(this.pipelineId + " was updated yeah!!");
        PipelineStatusManager.addPipelineStatus(this.pipelineId, this.makePipelineStatusMessage(PipelineStatusMessageType.PIPELINE_NO_DATA));
        SimilarStreamFinder streamFinder = new SimilarStreamFinder(this.pipelineId);
        if (streamFinder.isReplacable()) {
            System.out.println("Pipeline replacable");
            boolean success = new PipelineStreamReplacer(this.pipelineId, streamFinder.getSimilarStreams().get(0)).replaceStream();
            if (success) {
                System.out.println("success");
                PipelineStatusManager.addPipelineStatus(this.pipelineId, this.makePipelineStatusMessage(PipelineStatusMessageType.PIPELINE_EXCHANGE_SUCCESS));
            } else {
                System.out.println("failure");
                PipelineStatusManager.addPipelineStatus(this.pipelineId, this.makePipelineStatusMessage(PipelineStatusMessageType.PIPELINE_EXCHANGE_FAILURE));
            }
        } else {
            System.out.println("Pipeline not replacable");
            PipelineStatusManager.addPipelineStatus(this.pipelineId, this.makePipelineStatusMessage(PipelineStatusMessageType.PIPELINE_EXCHANGE_FAILURE));
        }
    }

    private PipelineStatusMessage makePipelineStatusMessage(PipelineStatusMessageType type) {
        return new PipelineStatusMessage(this.pipelineId, System.currentTimeMillis(), type.title(), type.description());
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pipelineId == null ? 0 : this.pipelineId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PipelineObserver other = (PipelineObserver)obj;
        return !(this.pipelineId == null ? other.pipelineId != null : !this.pipelineId.equals(other.pipelineId));
    }
}

