/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.monitoring.runtime;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.streampipes.manager.operations.Operations;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.client.pipeline.Pipeline;
import org.streampipes.model.graph.DataProcessorInvocation;
import org.streampipes.model.graph.DataSourceDescription;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.storage.api.IPipelineStorage;
import org.streampipes.storage.management.StorageDispatcher;
import org.streampipes.storage.management.StorageManager;

public class PipelineStreamReplacer {
    private String pipelineId;
    private SpDataStream streamToReplace;

    public PipelineStreamReplacer(String pipelineId, SpDataStream streamToReplace) {
        this.pipelineId = pipelineId;
        this.streamToReplace = streamToReplace;
    }

    public boolean replaceStream() {
        Pipeline currentPipeline = this.getPipelineStorage().getPipeline(this.pipelineId);
        String streamDomId = ((SpDataStream)currentPipeline.getStreams().get(0)).getDOM();
        Operations.stopPipeline(currentPipeline);
        currentPipeline = this.getPipelineStorage().getPipeline(this.pipelineId);
        try {
            this.streamToReplace.setDOM(streamDomId);
            currentPipeline.setStreams(Arrays.asList(this.streamToReplace));
            for (DataProcessorInvocation dataProcessorInvocation : currentPipeline.getSepas()) {
            }
            String newPipelineId = UUID.randomUUID().toString();
            currentPipeline.setPipelineId(newPipelineId);
            currentPipeline.setRev(null);
            currentPipeline.setName(currentPipeline.getName() + " (Replacement)");
            this.getPipelineStorage().storePipeline(currentPipeline);
            Operations.startPipeline(this.getPipelineStorage().getPipeline(newPipelineId));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            Operations.startPipeline(this.getPipelineStorage().getPipeline(this.pipelineId));
            return false;
        }
    }

    private IPipelineStorage getPipelineStorage() {
        return StorageDispatcher.INSTANCE.getNoSqlStore().getPipelineStorageAPI();
    }

    private String getElementId(String humanDescription) throws Exception {
        for (EventProperty p : this.streamToReplace.getEventSchema().getEventProperties()) {
            if (!p.getRuntimeName().equals(humanDescription)) continue;
            return p.getElementId();
        }
        throw new Exception("Property not found");
    }

    private DataSourceDescription getSep(SpDataStream streamToReplace2) throws Exception {
        List seps = StorageManager.INSTANCE.getStorageAPI().getAllSEPs();
        for (DataSourceDescription sep : seps) {
            for (SpDataStream stream : sep.getSpDataStreams()) {
                if (!stream.getElementId().equals(streamToReplace2.getElementId())) continue;
                return sep;
            }
        }
        throw new Exception("Stream not found");
    }
}

