/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.monitoring.runtime;

import java.util.ArrayList;
import java.util.List;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.client.pipeline.Pipeline;
import org.streampipes.model.graph.DataSourceDescription;
import org.streampipes.model.quality.MeasurementCapability;
import org.streampipes.model.quality.MeasurementObject;
import org.streampipes.storage.management.StorageDispatcher;
import org.streampipes.storage.management.StorageManager;

public class SimilarStreamFinder {
    private Pipeline pipeline;
    private List<SpDataStream> similarStreams;

    public SimilarStreamFinder(String pipelineId) {
        this.pipeline = StorageDispatcher.INSTANCE.getNoSqlStore().getPipelineStorageAPI().getPipeline(pipelineId);
        this.similarStreams = new ArrayList<SpDataStream>();
    }

    public boolean isReplacable() {
        if (this.pipeline.getStreams().size() > 1 || this.pipeline.getStreams().size() == 0) {
            return false;
        }
        return this.isSimilarStreamAvailable();
    }

    private boolean isSimilarStreamAvailable() {
        List seps = StorageManager.INSTANCE.getStorageAPI().getAllSEPs();
        List<SpDataStream> streams = this.getEventStreams(seps);
        SpDataStream pipelineInputStream = this.getStream();
        List pipelineInputStreamCapabilities = pipelineInputStream.getMeasurementCapability();
        List pipelineInputStreamMeasurementObject = pipelineInputStream.getMeasurementObject();
        for (SpDataStream stream : streams) {
            if (stream.getElementId().equals(pipelineInputStream.getElementId()) || !this.matchesStream(pipelineInputStreamCapabilities, pipelineInputStreamMeasurementObject, stream.getMeasurementCapability(), stream.getMeasurementObject())) continue;
            this.similarStreams.add(stream);
        }
        return this.similarStreams.size() > 0;
    }

    private boolean matchesStream(List<MeasurementCapability> pipelineInputStreamCapabilities, List<MeasurementObject> pipelineInputStreamMeasurementObject, List<MeasurementCapability> measurementCapability, List<MeasurementObject> measurementObject) {
        return this.matchesCapability(pipelineInputStreamCapabilities, measurementCapability) && this.matchesObject(pipelineInputStreamMeasurementObject, measurementObject);
    }

    private boolean matchesObject(List<MeasurementObject> pipelineInputStreamMeasurementObject, List<MeasurementObject> measurementObject) {
        if (pipelineInputStreamMeasurementObject == null | measurementObject == null) {
            return false;
        }
        return pipelineInputStreamMeasurementObject.stream().allMatch(p -> measurementObject.stream().anyMatch(mc -> mc.getMeasuresObject().toString().equals(p.getMeasuresObject().toString())));
    }

    private boolean matchesCapability(List<MeasurementCapability> pipelineInputStreamCapabilities, List<MeasurementCapability> measurementCapability) {
        if (pipelineInputStreamCapabilities == null || measurementCapability == null) {
            return false;
        }
        return pipelineInputStreamCapabilities.stream().allMatch(p -> measurementCapability.stream().anyMatch(mc -> mc.getCapability().toString().equals(p.getCapability().toString())));
    }

    private SpDataStream getStream() {
        String streamId = ((SpDataStream)this.pipeline.getStreams().get(0)).getElementId();
        return StorageManager.INSTANCE.getStorageAPI().getEventStreamById(streamId);
    }

    private List<SpDataStream> getEventStreams(List<DataSourceDescription> seps) {
        ArrayList<SpDataStream> result = new ArrayList<SpDataStream>();
        for (DataSourceDescription sep : seps) {
            result.addAll(sep.getSpDataStreams());
        }
        return result;
    }

    public List<SpDataStream> getSimilarStreams() {
        return this.similarStreams;
    }
}

