/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.monitoring.task;

import java.io.IOException;
import org.apache.http.client.ClientProtocolException;
import org.streampipes.manager.monitoring.job.MonitoringUtils;
import org.streampipes.manager.monitoring.task.TaskDefinition;
import org.streampipes.model.base.ConsumableStreamPipesEntity;
import org.streampipes.model.client.monitoring.TaskReport;

public class GetDescriptionTask
extends TaskDefinition {
    private ConsumableStreamPipesEntity element;
    private static final String TASK_NAME = "HTTP Get Availability consul";

    public GetDescriptionTask(ConsumableStreamPipesEntity element) {
        this.element = element;
    }

    @Override
    public void executeBefore() {
    }

    @Override
    public void executeAfter() {
    }

    @Override
    public TaskReport defineTaskExecution() {
        try {
            int statusCode = MonitoringUtils.getHttpResponse(this.element.getUri()).getStatusLine().getStatusCode();
            if (statusCode == 200) {
                return this.successMsg(TASK_NAME);
            }
            return this.errorMsg(TASK_NAME, "Wrong status code");
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            return this.errorMsg(TASK_NAME, e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.errorMsg(TASK_NAME, e.getMessage());
        }
    }
}

