/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.operations;

import java.util.ArrayList;
import java.util.List;
import org.streampipes.commons.exceptions.NoSuitableSepasAvailableException;
import org.streampipes.commons.exceptions.SepaParseException;
import org.streampipes.commons.exceptions.SpRuntimeException;
import org.streampipes.manager.endpoint.EndpointItemFetcher;
import org.streampipes.manager.execution.http.PipelineExecutor;
import org.streampipes.manager.execution.http.PipelineStorageService;
import org.streampipes.manager.matching.DataSetGroundingSelector;
import org.streampipes.manager.matching.PipelineVerificationHandler;
import org.streampipes.manager.recommender.ElementRecommender;
import org.streampipes.manager.remote.ContainerProvidedOptionsHandler;
import org.streampipes.manager.runtime.PipelineElementRuntimeInfoFetcher;
import org.streampipes.manager.template.PipelineTemplateGenerator;
import org.streampipes.manager.template.PipelineTemplateInvocationGenerator;
import org.streampipes.manager.template.PipelineTemplateInvocationHandler;
import org.streampipes.manager.topic.WildcardTopicGenerator;
import org.streampipes.manager.verification.extractor.TypeExtractor;
import org.streampipes.model.SpDataSet;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.client.endpoint.RdfEndpoint;
import org.streampipes.model.client.endpoint.RdfEndpointItem;
import org.streampipes.model.client.messages.Message;
import org.streampipes.model.client.pipeline.DataSetModificationMessage;
import org.streampipes.model.client.pipeline.Pipeline;
import org.streampipes.model.client.pipeline.PipelineElementRecommendationMessage;
import org.streampipes.model.client.pipeline.PipelineModificationMessage;
import org.streampipes.model.client.pipeline.PipelineOperationStatus;
import org.streampipes.model.client.runtime.ContainerProvidedOptionsParameterRequest;
import org.streampipes.model.staticproperty.Option;
import org.streampipes.model.template.PipelineTemplateDescription;
import org.streampipes.model.template.PipelineTemplateInvocation;
import org.streampipes.storage.management.StorageDispatcher;

public class Operations {
    public static PipelineModificationMessage validatePipeline(Pipeline pipeline, boolean isPartial) throws Exception {
        return Operations.validatePipeline(pipeline, isPartial, "");
    }

    public static PipelineModificationMessage validatePipeline(Pipeline pipeline, boolean isPartial, String username) throws Exception {
        PipelineVerificationHandler validator = new PipelineVerificationHandler(pipeline);
        return validator.validateConnection().computeMappingProperties().storeConnection().getPipelineModificationMessage();
    }

    public static DataSetModificationMessage updateDataSet(SpDataSet dataSet) {
        return new DataSetGroundingSelector(dataSet).selectGrounding();
    }

    public static Message verifyAndAddElement(String graphData, String username) throws SepaParseException {
        return Operations.verifyAndAddElement(graphData, username, false);
    }

    public static Message verifyAndAddElement(String graphData, String username, boolean publicElement) throws SepaParseException {
        return new TypeExtractor(graphData).getTypeVerifier().verifyAndAdd(username, publicElement);
    }

    public static Message verifyAndUpdateElement(String graphData, String username) throws SepaParseException {
        return new TypeExtractor(graphData).getTypeVerifier().verifyAndUpdate(username);
    }

    public static PipelineElementRecommendationMessage findRecommendedElements(String email, Pipeline partialPipeline) throws NoSuitableSepasAvailableException {
        return new ElementRecommender(email, partialPipeline).findRecommendedElements();
    }

    public static void storePipeline(Pipeline pipeline) {
        new PipelineStorageService(pipeline).addPipeline();
    }

    public static PipelineOperationStatus startPipeline(Pipeline pipeline) {
        return Operations.startPipeline(pipeline, true, true, false);
    }

    public static PipelineOperationStatus startPipeline(Pipeline pipeline, boolean visualize, boolean storeStatus, boolean monitor) {
        return new PipelineExecutor(pipeline, visualize, storeStatus, monitor).startPipeline();
    }

    public static PipelineOperationStatus stopPipeline(Pipeline pipeline) {
        return Operations.stopPipeline(pipeline, true, true, false);
    }

    public static List<PipelineOperationStatus> stopAllPipelines() {
        ArrayList<PipelineOperationStatus> status = new ArrayList<PipelineOperationStatus>();
        List pipelines = StorageDispatcher.INSTANCE.getNoSqlStore().getPipelineStorageAPI().getAllPipelines();
        pipelines.forEach(p -> {
            if (p.isRunning()) {
                status.add(Operations.stopPipeline(p));
            }
        });
        return status;
    }

    public static PipelineOperationStatus stopPipeline(Pipeline pipeline, boolean visualize, boolean storeStatus, boolean monitor) {
        return new PipelineExecutor(pipeline, visualize, storeStatus, monitor).stopPipeline();
    }

    public static List<RdfEndpointItem> getEndpointUriContents(List<RdfEndpoint> endpoints) {
        return new EndpointItemFetcher(endpoints).getItems();
    }

    public static SpDataStream updateActualTopic(SpDataStream stream) {
        return new WildcardTopicGenerator(stream).computeActualTopic();
    }

    public static List<Option> fetchRemoteOptions(ContainerProvidedOptionsParameterRequest request) {
        return new ContainerProvidedOptionsHandler().fetchRemoteOptions(request);
    }

    public static List<PipelineTemplateDescription> getAllPipelineTemplates() {
        return new PipelineTemplateGenerator().getAllPipelineTemplates();
    }

    public static List<PipelineTemplateDescription> getCompatiblePipelineTemplates(String streamId) {
        return new PipelineTemplateGenerator().getCompatibleTemplates(streamId);
    }

    public static PipelineOperationStatus handlePipelineTemplateInvocation(String username, PipelineTemplateInvocation pipelineTemplateInvocation) {
        return new PipelineTemplateInvocationHandler(username, pipelineTemplateInvocation).handlePipelineInvocation();
    }

    public static PipelineOperationStatus handlePipelineTemplateInvocation(String username, PipelineTemplateInvocation pipelineTemplateInvocation, PipelineTemplateDescription pipelineTemplateDescription) {
        return new PipelineTemplateInvocationHandler(username, pipelineTemplateInvocation, pipelineTemplateDescription).handlePipelineInvocation();
    }

    public static PipelineTemplateInvocation getPipelineInvocationTemplate(SpDataStream dataStream, PipelineTemplateDescription pipelineTemplateDescription) {
        return new PipelineTemplateInvocationGenerator(dataStream, pipelineTemplateDescription).generateInvocation();
    }

    public static String getRuntimeInfo(SpDataStream spDataStream) throws SpRuntimeException {
        return PipelineElementRuntimeInfoFetcher.INSTANCE.getCurrentData(spDataStream);
    }
}

