/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.recommender;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.streampipes.commons.exceptions.NoSepaInPipelineException;
import org.streampipes.commons.exceptions.NoSuitableSepasAvailableException;
import org.streampipes.manager.matching.PipelineVerificationHandler;
import org.streampipes.manager.matching.v2.StreamMatch;
import org.streampipes.manager.storage.UserManagementService;
import org.streampipes.manager.util.PipelineVerificationUtils;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.ConsumableStreamPipesEntity;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.client.exception.InvalidConnectionException;
import org.streampipes.model.client.matching.MatchingResultMessage;
import org.streampipes.model.client.pipeline.Pipeline;
import org.streampipes.model.client.pipeline.PipelineElementRecommendation;
import org.streampipes.model.client.pipeline.PipelineElementRecommendationMessage;
import org.streampipes.model.graph.DataProcessorDescription;
import org.streampipes.model.graph.DataProcessorInvocation;
import org.streampipes.model.graph.DataSinkDescription;
import org.streampipes.model.graph.DataSinkInvocation;
import org.streampipes.storage.api.INoSqlStorage;
import org.streampipes.storage.api.IPipelineElementDescriptionStorage;
import org.streampipes.storage.management.StorageDispatcher;
import org.streampipes.storage.management.StorageManager;

public class ElementRecommender {
    private Pipeline pipeline;
    private String email;
    private PipelineElementRecommendationMessage recommendationMessage;

    public ElementRecommender(String email, Pipeline partialPipeline) {
        this.email = email;
        this.pipeline = partialPipeline;
        this.recommendationMessage = new PipelineElementRecommendationMessage();
    }

    public PipelineElementRecommendationMessage findRecommendedElements() throws NoSuitableSepasAvailableException {
        String rootNodeElementId;
        try {
            rootNodeElementId = this.getRootNodeElementId(this.getRootNode());
            Optional<SpDataStream> outputStream = this.getOutputStream();
            outputStream.ifPresent(spDataStream -> this.validate((SpDataStream)spDataStream, this.getAll()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.recommendationMessage;
        }
        if (this.recommendationMessage.getPossibleElements().size() == 0) {
            throw new NoSuitableSepasAvailableException();
        }
        this.recommendationMessage.setRecommendedElements(this.calculateWeights(this.filterOldElements(this.getNoSqlStorage().getConnectionStorageApi().getRecommendedElements(rootNodeElementId))));
        return this.recommendationMessage;
    }

    private List<PipelineElementRecommendation> filterOldElements(List<PipelineElementRecommendation> recommendedElements) {
        return recommendedElements.stream().filter((? super T r) -> this.getAll().stream().anyMatch(a -> a.getElementId().equals(r.getElementId()))).collect(Collectors.toList());
    }

    private List<PipelineElementRecommendation> calculateWeights(List<PipelineElementRecommendation> recommendedElements) {
        int allConnectionsCount = recommendedElements.stream().mapToInt(PipelineElementRecommendation::getCount).sum();
        recommendedElements.forEach(r -> {
            r.setWeight(this.getWeight(r.getCount(), allConnectionsCount));
            r.setName(this.getName(r.getElementId()));
            r.setDescription(this.getDescription(r.getElementId()));
        });
        return recommendedElements;
    }

    private String getName(String elementId) {
        return this.filter(elementId).getName();
    }

    private String getDescription(String elementId) {
        return this.filter(elementId).getDescription();
    }

    private NamedStreamPipesEntity filter(String elementId) {
        List<ConsumableStreamPipesEntity> allElements = this.getAll();
        return (NamedStreamPipesEntity)allElements.stream().filter((? super T a) -> a.getElementId().equals(elementId)).findFirst().get();
    }

    private Float getWeight(Integer count, Integer allConnectionsCount) {
        return Float.valueOf((float)count.intValue() / (float)allConnectionsCount.intValue());
    }

    private void validate(SpDataStream offer, List<ConsumableStreamPipesEntity> entities) {
        for (ConsumableStreamPipesEntity sepa : entities) {
            SpDataStream requirement = (SpDataStream)sepa.getSpDataStreams().get(0);
            requirement.setEventGrounding(sepa.getSupportedGrounding());
            ArrayList<MatchingResultMessage> messages = new ArrayList<MatchingResultMessage>();
            Boolean matches = new StreamMatch().match(offer, requirement, (List<MatchingResultMessage>)messages);
            if (!matches.booleanValue()) continue;
            this.addPossibleElements((NamedStreamPipesEntity)sepa);
        }
    }

    private void addPossibleElements(NamedStreamPipesEntity sepa) {
        this.recommendationMessage.addPossibleElement(new PipelineElementRecommendation(sepa.getElementId(), sepa.getName(), sepa.getDescription()));
    }

    private List<ConsumableStreamPipesEntity> getAllSepas() {
        List<String> userObjects = UserManagementService.getUserService().getOwnSepaUris(this.email);
        return this.getTripleStore().getAllSEPAs().stream().filter((? super T e) -> userObjects.stream().anyMatch(u -> u.equals(e.getElementId()))).map(DataProcessorDescription::new).collect(Collectors.toList());
    }

    private List<ConsumableStreamPipesEntity> getAllSecs() {
        List<String> userObjects = UserManagementService.getUserService().getOwnActionUris(this.email);
        return this.getTripleStore().getAllSECs().stream().filter((? super T e) -> userObjects.stream().anyMatch(u -> u.equals(e.getElementId()))).map(DataSinkDescription::new).collect(Collectors.toList());
    }

    private List<ConsumableStreamPipesEntity> getAll() {
        ArrayList<ConsumableStreamPipesEntity> allElements = new ArrayList<ConsumableStreamPipesEntity>();
        allElements.addAll(this.getAllSepas());
        allElements.addAll(this.getAllSecs());
        return allElements;
    }

    private IPipelineElementDescriptionStorage getTripleStore() {
        return StorageManager.INSTANCE.getStorageAPI();
    }

    private NamedStreamPipesEntity getRootNode() throws NoSepaInPipelineException {
        if (this.pipeline.getSepas().size() == 0 && this.pipeline.getActions().size() == 0) {
            return (NamedStreamPipesEntity)this.pipeline.getStreams().get(this.pipeline.getStreams().size() - 1);
        }
        return PipelineVerificationUtils.getRootNode(this.pipeline);
    }

    private String getRootNodeElementId(NamedStreamPipesEntity entity) {
        if (entity instanceof InvocableStreamPipesEntity) {
            return ((InvocableStreamPipesEntity)entity).getBelongsTo();
        }
        return entity.getElementId();
    }

    private INoSqlStorage getNoSqlStorage() {
        return StorageDispatcher.INSTANCE.getNoSqlStore();
    }

    private Optional<SpDataStream> getOutputStream() throws NoSepaInPipelineException, InvalidConnectionException {
        NamedStreamPipesEntity rootNode = this.getRootNode();
        if (rootNode instanceof SpDataStream) {
            return Optional.of((SpDataStream)rootNode);
        }
        if (rootNode instanceof DataSinkInvocation) {
            return Optional.empty();
        }
        List<InvocableStreamPipesEntity> graphs = new PipelineVerificationHandler(this.pipeline).validateConnection().makeInvocationGraphs();
        Optional<InvocableStreamPipesEntity> rootElementWithOutputStream = graphs.stream().filter((? super T g) -> g.getElementId().equals(rootNode.getElementId())).findFirst();
        if (rootElementWithOutputStream.isPresent() && rootElementWithOutputStream.get() instanceof DataProcessorInvocation) {
            return Optional.of(((DataProcessorInvocation)rootElementWithOutputStream.get()).getOutputStream());
        }
        return Optional.empty();
    }
}

