/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.remote;

import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.streampipes.model.client.runtime.ContainerProvidedOptionsParameterRequest;
import org.streampipes.model.runtime.RuntimeOptionsRequest;
import org.streampipes.model.runtime.RuntimeOptionsResponse;
import org.streampipes.model.staticproperty.Option;
import org.streampipes.serializers.json.GsonSerializer;

public class ContainerProvidedOptionsHandler {
    public List<Option> fetchRemoteOptions(ContainerProvidedOptionsParameterRequest parameterRequest) {
        RuntimeOptionsRequest request = new RuntimeOptionsRequest();
        request.setRequestId(parameterRequest.getRuntimeResolvableInternalId());
        request.setInputStreams(parameterRequest.getInputStreams());
        request.setStaticProperties(parameterRequest.getStaticProperties());
        String httpRequestBody = GsonSerializer.getGsonWithIds().toJson((Object)request);
        try {
            Response httpResp = Request.Post((String)(parameterRequest.getBelongsTo() + "/configurations")).bodyString(httpRequestBody, ContentType.APPLICATION_JSON).execute();
            return this.handleResponse(httpResp);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Option>();
        }
    }

    private List<Option> handleResponse(Response httpResp) throws JsonSyntaxException, IOException {
        String resp = httpResp.returnContent().asString();
        RuntimeOptionsResponse response = (RuntimeOptionsResponse)GsonSerializer.getGsonWithIds().fromJson(resp, RuntimeOptionsResponse.class);
        return response.getOptions().stream().map(Option::new).collect(Collectors.toList());
    }
}

