/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.runtime;

import org.streampipes.dataformat.SpDataFormatDefinition;
import org.streampipes.dataformat.cbor.CborDataFormatDefinition;
import org.streampipes.dataformat.fst.FstDataFormatDefinition;
import org.streampipes.dataformat.json.JsonDataFormatDefinition;
import org.streampipes.dataformat.smile.SmileDataFormatDefinition;
import org.streampipes.manager.runtime.SpDataFormatConverter;
import org.streampipes.model.grounding.TransportFormat;

public class SpDataFormatConverterGenerator {
    private TransportFormat transportFormat;

    public SpDataFormatConverterGenerator(TransportFormat transportFormat) {
        this.transportFormat = transportFormat;
    }

    public SpDataFormatConverter makeConverter() {
        if (this.isJsonFormat(this.transportFormat).booleanValue()) {
            return new SpDataFormatConverter((SpDataFormatDefinition)new JsonDataFormatDefinition());
        }
        if (this.isCborFormat(this.transportFormat)) {
            return new SpDataFormatConverter((SpDataFormatDefinition)new CborDataFormatDefinition());
        }
        if (this.isFstFormat(this.transportFormat)) {
            return new SpDataFormatConverter((SpDataFormatDefinition)new FstDataFormatDefinition());
        }
        if (this.isSmileFormat(this.transportFormat)) {
            return new SpDataFormatConverter((SpDataFormatDefinition)new SmileDataFormatDefinition());
        }
        throw new IllegalArgumentException("Wrong transport format: " + this.makeError(this.transportFormat));
    }

    private boolean isSmileFormat(TransportFormat transportFormat) {
        return this.isFormat("http://sepa.event-processing.org/sepa#smile", transportFormat);
    }

    private boolean isFstFormat(TransportFormat transportFormat) {
        return this.isFormat("http://sepa.event-processing.org/sepa#fst", transportFormat);
    }

    private boolean isCborFormat(TransportFormat transportFormat) {
        return this.isFormat("http://sepa.event-processing.org/sepa#cbor", transportFormat);
    }

    private Boolean isJsonFormat(TransportFormat transportFormat) {
        return this.isFormat("http://sepa.event-processing.org/sepa#json", transportFormat);
    }

    private boolean isFormat(String format, TransportFormat transportFormat) {
        return transportFormat.getRdfType().stream().anyMatch(tf -> tf.toString().equals(format));
    }

    private String makeError(TransportFormat transportFormat) {
        StringBuilder builder = new StringBuilder();
        transportFormat.getRdfType().forEach(type -> builder.append(type.toString()).append(", "));
        return builder.toString();
    }
}

