/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.selector;

import java.util.Collections;
import java.util.List;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventPropertyNested;
import org.streampipes.model.schema.EventSchema;

public class PropertyFinder {
    private EventSchema schema;
    private String[] propertySelectors;

    public PropertyFinder(EventSchema schema, String propertySelector) {
        this.schema = schema;
        this.propertySelectors = propertySelector.split("::");
    }

    public List<EventProperty> findProperty() {
        return this.findProperty(this.schema.getEventProperties(), 1);
    }

    public List<EventProperty> findProperty(List<EventProperty> properties, Integer currentPointer) {
        for (EventProperty property : properties) {
            if (!property.getRuntimeName().equals(this.propertySelectors[currentPointer])) continue;
            if (currentPointer == this.propertySelectors.length - 1) {
                return Collections.singletonList(property);
            }
            return this.findProperty(((EventPropertyNested)property).getEventProperties(), currentPointer + 1);
        }
        return Collections.emptyList();
    }
}

