/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.selector;

import java.util.List;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.schema.EventProperty;

public class PropertyRequirementSelector {
    private String requirementSelector;

    public PropertyRequirementSelector(String requirementSelector) {
        this.requirementSelector = requirementSelector;
    }

    public EventProperty findPropertyRequirement(List<SpDataStream> streamRequirements) throws IllegalArgumentException {
        SpDataStream affectedStream = this.getAffectedStream(streamRequirements);
        for (EventProperty property : affectedStream.getEventSchema().getEventProperties()) {
            if (!this.makePropertySelector(property.getRuntimeName()).equals(this.requirementSelector)) continue;
            return property;
        }
        throw new IllegalArgumentException("Could not find requirement as specified by selector.");
    }

    private String makePropertySelector(String runtimeName) {
        return this.getAffectedRequirementPrefix() + "::" + runtimeName;
    }

    public SpDataStream getAffectedStream(List<SpDataStream> streams) {
        Integer affectedStreamIndex = this.getAffectedStreamIndex();
        if (affectedStreamIndex == 0) {
            return streams.get(0);
        }
        if (affectedStreamIndex == 1 && streams.size() > 1) {
            return streams.get(1);
        }
        throw new IllegalArgumentException("Wrong requirement selector provided.");
    }

    private Integer getAffectedStreamIndex() {
        if (this.requirementSelector.startsWith("r0")) {
            return 0;
        }
        return 1;
    }

    private String getAffectedRequirementPrefix() {
        Integer affectedStreamIndex = this.getAffectedStreamIndex();
        if (affectedStreamIndex == 0) {
            return "r0";
        }
        return "r1";
    }

    public String getAffectedStreamPrefix() {
        Integer affectedStreamIndex = this.getAffectedStreamIndex();
        if (affectedStreamIndex == 0) {
            return "s0";
        }
        return "s1";
    }
}

