/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.selector;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.streampipes.manager.selector.PropertySelectorUtils;
import org.streampipes.model.output.PropertyRenameRule;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventPropertyNested;
import org.streampipes.model.schema.EventSchema;
import org.streampipes.model.util.Cloner;
import org.streampipes.sdk.helpers.Tuple2;

public class PropertySelector {
    private EventSchema firstSchema;
    private EventSchema secondSchema;
    private List<EventProperty> outputProperties = new ArrayList<EventProperty>();
    private List<PropertyRenameRule> propertyRenameRules = new ArrayList<PropertyRenameRule>();

    public PropertySelector() {
    }

    public PropertySelector(EventSchema firstSchema) {
        this();
        this.firstSchema = firstSchema;
    }

    public PropertySelector(EventSchema firstSchema, EventSchema secondSchema) {
        this();
        this.firstSchema = firstSchema;
        this.secondSchema = secondSchema;
    }

    private List<EventProperty> extractProperties(List<EventProperty> inputProperties, List<String> propertySelectors, String currentPropertyPointer, List<EventProperty> appendProperties) {
        ArrayList<EventProperty> outputProperties = new ArrayList<EventProperty>();
        for (EventProperty inputProperty : inputProperties) {
            for (String propertySelector : propertySelectors) {
                if (!this.isInSelection(inputProperty, propertySelector, currentPropertyPointer)) continue;
                EventProperty outputProperty = new Cloner().property(inputProperty);
                if (outputProperty instanceof EventPropertyNested) {
                    ((EventPropertyNested)outputProperty).setEventProperties(this.extractProperties(((EventPropertyNested)outputProperty).getEventProperties(), propertySelectors, this.makeSelector(currentPropertyPointer, inputProperty.getRuntimeName()), appendProperties));
                }
                if (this.isPresent(outputProperty.getRuntimeName(), outputProperties, appendProperties).booleanValue()) {
                    String newRuntimeName = this.createRuntimeName(outputProperty.getRuntimeName(), outputProperties, appendProperties);
                    this.propertyRenameRules.add(new PropertyRenameRule(this.makeSelector(currentPropertyPointer, outputProperty.getRuntimeName()), newRuntimeName));
                    outputProperty.setRuntimeName(newRuntimeName);
                }
                outputProperties.add(new Cloner().property(outputProperty));
            }
        }
        return outputProperties;
    }

    private String createRuntimeName(String runtimeName, List<EventProperty> outputProperties, List<EventProperty> appendProperties) {
        int i = 0;
        while (true) {
            if (!this.isPresent(runtimeName + "_" + i, outputProperties, appendProperties).booleanValue()) break;
            ++i;
        }
        String newRuntimeName = runtimeName + "_" + i;
        return newRuntimeName;
    }

    private Boolean isPresent(String runtimeName, List<EventProperty> outputProperties, List<EventProperty> appendProperties) {
        return outputProperties.stream().anyMatch(p -> p.getRuntimeName().equals(runtimeName)) || this.outputProperties.stream().anyMatch(p -> p.getRuntimeName().equals(runtimeName)) || appendProperties.stream().anyMatch(ap -> ap.getRuntimeName().equals(runtimeName));
    }

    private boolean isInSelection(EventProperty inputProperty, String propertySelector, String currentPropertyPointer) {
        return (currentPropertyPointer + "::" + inputProperty.getRuntimeName()).equals(propertySelector);
    }

    public List<EventProperty> createPropertyList(List<String> propertySelectors) {
        return this.createPropertyList(propertySelectors, new ArrayList<EventProperty>());
    }

    public List<EventProperty> createPropertyList(List<String> propertySelectors, List<EventProperty> appendProperties) {
        this.outputProperties.addAll(this.extractProperties(PropertySelectorUtils.getProperties(this.firstSchema), this.getPropertySelectors(propertySelectors, "s0"), "s0", appendProperties));
        this.outputProperties.addAll(this.extractProperties(PropertySelectorUtils.getProperties(this.secondSchema), this.getPropertySelectors(propertySelectors, "s1"), "s1", appendProperties));
        this.outputProperties.addAll(appendProperties.stream().map(ep -> new Cloner().property(ep)).collect(Collectors.toList()));
        return this.outputProperties;
    }

    public Tuple2<List<EventProperty>, List<PropertyRenameRule>> createRenamedPropertyList(List<String> propertySelectors) {
        return new Tuple2(this.createPropertyList(propertySelectors, new ArrayList<EventProperty>()), this.propertyRenameRules);
    }

    public Tuple2<List<EventProperty>, List<PropertyRenameRule>> createRenamedPropertyList(List<String> propertySelectors, List<EventProperty> appendProperties) {
        return new Tuple2(this.createPropertyList(propertySelectors, appendProperties), this.propertyRenameRules);
    }

    private String makeSelector(String prefix, String current) {
        return prefix + "::" + current;
    }

    private List<String> getPropertySelectors(List<String> propertySelectors, String prefix) {
        return propertySelectors.stream().filter(s -> s.startsWith(prefix)).collect(Collectors.toList());
    }
}

