/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.selector;

import java.util.ArrayList;
import java.util.List;
import org.streampipes.manager.selector.PropertySelectorUtils;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventPropertyNested;
import org.streampipes.model.schema.EventSchema;

public class PropertySelectorGenerator {
    private EventSchema firstSchema;
    private EventSchema secondSchema;
    private Boolean omitNestedProperties;

    public PropertySelectorGenerator(List<EventProperty> eventProperties, Boolean omitNestedProperties) {
        this.firstSchema = new EventSchema(eventProperties);
        this.omitNestedProperties = omitNestedProperties;
    }

    public PropertySelectorGenerator(EventSchema firstSchema, Boolean omitNestedProperties) {
        this.firstSchema = firstSchema;
        this.omitNestedProperties = omitNestedProperties;
    }

    public PropertySelectorGenerator(EventSchema firstSchema, EventSchema secondSchema, Boolean omitNestedProperties) {
        this.firstSchema = firstSchema;
        this.secondSchema = secondSchema;
        this.omitNestedProperties = omitNestedProperties;
    }

    public List<String> generateSelectors() {
        ArrayList<String> propertySelectors = new ArrayList<String>();
        propertySelectors.addAll(this.generateSelectors(PropertySelectorUtils.getProperties(this.firstSchema), "s0"));
        propertySelectors.addAll(this.generateSelectors(PropertySelectorUtils.getProperties(this.secondSchema), "s1"));
        return propertySelectors;
    }

    public List<String> generateSelectors(String prefix) {
        return this.generateSelectors(this.firstSchema.getEventProperties(), prefix);
    }

    private List<String> generateSelectors(List<EventProperty> eventProperties, String prefix) {
        ArrayList<String> propertySelectors = new ArrayList<String>();
        for (EventProperty ep : eventProperties) {
            if (ep instanceof EventPropertyNested) {
                propertySelectors.addAll(this.generateSelectors(((EventPropertyNested)ep).getEventProperties(), this.makeSelector(prefix, ep.getRuntimeName())));
            }
            if (ep instanceof EventPropertyNested && this.omitNestedProperties.booleanValue()) continue;
            propertySelectors.add(this.makeSelector(prefix, ep.getRuntimeName()));
        }
        return propertySelectors;
    }

    private String makeSelector(String prefix, String runtimeName) {
        return prefix + "::" + runtimeName;
    }
}

