/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.setup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.lightcouch.DesignDocument;
import org.lightcouch.Response;
import org.streampipes.manager.setup.InstallationStep;
import org.streampipes.model.client.endpoint.RdfEndpoint;
import org.streampipes.model.client.messages.Message;
import org.streampipes.model.client.messages.Notifications;
import org.streampipes.storage.couchdb.impl.RdfEndpointStorageImpl;
import org.streampipes.storage.couchdb.utils.Utils;

public class CouchDbInstallationStep
implements InstallationStep {
    private static List<String> initRdfEndpointPorts = Arrays.asList("8099/api/v1/admin@streampipes.org/master/sources/");
    private static final String initRdfEndpointHost = "http://localhost:";

    @Override
    public List<Message> install() {
        ArrayList<Message> msgs = new ArrayList<Message>();
        msgs.addAll(this.createDatabases());
        msgs.addAll(this.createViews());
        msgs.add(this.addRdfEndpoints());
        return msgs;
    }

    @Override
    public String getTitle() {
        return "Creating CouchDB databases...";
    }

    private List<Message> createDatabases() {
        try {
            Utils.getCouchDbInternalUsersClient();
            Utils.getCouchDbReplicatorClient();
            Utils.getCouchDbGlobalChangesClient();
            Utils.getCouchDbUserClient();
            Utils.getCouchDbMonitoringClient();
            Utils.getCouchDbPipelineClient();
            Utils.getCouchDbConnectionClient();
            Utils.getCouchDbNotificationClient();
            Utils.getCouchDbPipelineCategoriesClient();
            Utils.getCouchDbVisualizationClient();
            Utils.getCouchDbRdfEndpointClient();
            Utils.getCouchDbDashboardClient();
            Utils.getCouchDbVisualizablePipelineClient();
            return Arrays.asList(Notifications.success((String)this.getTitle()));
        }
        catch (Exception e) {
            return Arrays.asList(Notifications.error((String)this.getTitle()));
        }
    }

    private List<Message> createViews() {
        ArrayList<Message> result = new ArrayList<Message>();
        result.add(this.addUserView());
        result.add(this.addConnectionView());
        return result;
    }

    private Message addRdfEndpoints() {
        RdfEndpointStorageImpl rdfEndpointStorage = new RdfEndpointStorageImpl();
        initRdfEndpointPorts.forEach(p -> rdfEndpointStorage.addRdfEndpoint(new RdfEndpoint(initRdfEndpointHost + p)));
        return Notifications.success((String)"Creating RDF endpoints...");
    }

    private Message addUserView() {
        try {
            DesignDocument userDocument = this.prepareDocument("_design/users");
            HashMap<String, DesignDocument.MapReduce> views = new HashMap<String, DesignDocument.MapReduce>();
            DesignDocument.MapReduce passwordFunction = new DesignDocument.MapReduce();
            passwordFunction.setMap("function(doc) { if(doc.email&& doc.password) { emit(doc.email, doc.password); } }");
            DesignDocument.MapReduce usernameFunction = new DesignDocument.MapReduce();
            usernameFunction.setMap("function(doc) { if(doc.email) { emit(doc.email, doc); } }");
            views.put("password", passwordFunction);
            views.put("username", usernameFunction);
            userDocument.setViews(views);
            Response resp = Utils.getCouchDbUserClient().design().synchronizeWithDb(userDocument);
            if (resp.getError() != null) {
                return Notifications.error((String)"Preparing database 'users'...");
            }
            return Notifications.success((String)"Preparing database 'users'...");
        }
        catch (Exception e) {
            return Notifications.error((String)"Preparing database 'users'...");
        }
    }

    private Message addConnectionView() {
        try {
            DesignDocument connectionDocument = this.prepareDocument("_design/connection");
            HashMap<String, DesignDocument.MapReduce> views = new HashMap<String, DesignDocument.MapReduce>();
            DesignDocument.MapReduce frequentFunction = new DesignDocument.MapReduce();
            frequentFunction.setMap("function(doc) { if(doc.from && doc.to) { emit([doc.from, doc.to] , 1 ); } }");
            frequentFunction.setReduce("function (key, values) { return sum(values); }");
            views.put("frequent", frequentFunction);
            connectionDocument.setViews(views);
            Response resp = Utils.getCouchDbConnectionClient().design().synchronizeWithDb(connectionDocument);
            if (resp.getError() != null) {
                return Notifications.error((String)"Preparing database 'connection'...");
            }
            return Notifications.success((String)"Preparing database 'connection'...");
        }
        catch (Exception e) {
            return Notifications.error((String)"Preparing database 'connection'...");
        }
    }

    private DesignDocument prepareDocument(String id) {
        DesignDocument doc = new DesignDocument();
        doc.setLanguage("javascript");
        doc.setId(id);
        return doc;
    }
}

