/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.setup;

import java.util.ArrayList;
import java.util.List;
import org.streampipes.config.backend.BackendConfig;
import org.streampipes.manager.endpoint.EndpointFetcher;
import org.streampipes.manager.setup.CouchDbInstallationStep;
import org.streampipes.manager.setup.InstallationStep;
import org.streampipes.manager.setup.PipelineElementInstallationStep;
import org.streampipes.manager.setup.SesameDbInstallationStep;
import org.streampipes.manager.setup.UserRegistrationInstallationStep;
import org.streampipes.model.client.endpoint.RdfEndpoint;
import org.streampipes.model.client.setup.InitialSettings;
import org.streampipes.storage.couchdb.utils.CouchDbConfig;
import org.streampipes.storage.rdf4j.util.SesameConfig;

public class InstallationConfiguration {
    public static List<InstallationStep> getInstallationSteps(InitialSettings settings) {
        InstallationConfiguration.setInitialConfiguration(settings);
        ArrayList<InstallationStep> steps = new ArrayList<InstallationStep>();
        steps.add(new SesameDbInstallationStep());
        steps.add(new CouchDbInstallationStep());
        steps.add(new UserRegistrationInstallationStep(settings.getAdminEmail(), settings.getAdminPassword()));
        if (settings.getInstallPipelineElements().booleanValue()) {
            for (RdfEndpoint endpoint : new EndpointFetcher().getEndpoints()) {
                steps.add(new PipelineElementInstallationStep(endpoint, settings.getAdminEmail()));
            }
        }
        return steps;
    }

    private static void setInitialConfiguration(InitialSettings s) {
        if (!"".equals(s.getCouchDbHost())) {
            CouchDbConfig.INSTANCE.setHost(s.getCouchDbHost());
        }
        if (!"".equals(s.getSesameHost())) {
            SesameConfig.INSTANCE.setUri("http://" + s.getSesameHost() + ":8031/rdf4j-server");
        }
        if (!"".equals(s.getKafkaHost())) {
            BackendConfig.INSTANCE.setKafkaHost(s.getKafkaHost());
        }
        if (!"".equals(s.getZookeeperHost())) {
            BackendConfig.INSTANCE.setZookeeperHost(s.getZookeeperHost());
        }
        if (!"".equals(s.getJmsHost())) {
            BackendConfig.INSTANCE.setJmsHost(s.getJmsHost());
        }
    }
}

