/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.setup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.streampipes.manager.endpoint.EndpointItemParser;
import org.streampipes.manager.operations.Operations;
import org.streampipes.manager.setup.InstallationStep;
import org.streampipes.model.client.endpoint.RdfEndpoint;
import org.streampipes.model.client.endpoint.RdfEndpointItem;
import org.streampipes.model.client.messages.Message;
import org.streampipes.model.client.messages.Notifications;

public class PipelineElementInstallationStep
implements InstallationStep {
    private RdfEndpoint endpoint;
    private String userEmail;

    public PipelineElementInstallationStep(RdfEndpoint endpoint, String userEmail) {
        this.endpoint = endpoint;
        this.userEmail = userEmail;
    }

    @Override
    public List<Message> install() {
        ArrayList<Message> statusMessages = new ArrayList<Message>();
        List<RdfEndpointItem> items = Operations.getEndpointUriContents(Collections.singletonList(this.endpoint));
        for (RdfEndpointItem item : items) {
            statusMessages.add(new EndpointItemParser().parseAndAddEndpointItem(item.getUri(), this.userEmail, true));
        }
        Object installMessage = statusMessages.stream().allMatch(Message::isSuccess) ? Notifications.success((String)this.getTitle()) : Notifications.error((String)this.getTitle());
        return Collections.singletonList(installMessage);
    }

    @Override
    public String getTitle() {
        return "Installing pipeline elements from " + this.endpoint.getEndpointUrl();
    }
}

