/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.setup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.repository.manager.RemoteRepositoryManager;
import org.eclipse.rdf4j.repository.sail.config.SailRepositoryConfig;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.inferencer.fc.config.ForwardChainingRDFSInferencerConfig;
import org.eclipse.rdf4j.sail.memory.config.MemoryStoreConfig;
import org.streampipes.manager.setup.InstallationStep;
import org.streampipes.model.client.messages.Message;
import org.streampipes.model.client.messages.Notifications;
import org.streampipes.storage.management.StorageManager;
import org.streampipes.storage.rdf4j.util.SesameConfig;

public class SesameDbInstallationStep
implements InstallationStep {
    private String sesameUrl = SesameConfig.INSTANCE.getUri();
    private String sesameDbName = SesameConfig.INSTANCE.getRepositoryId();

    @Override
    public List<Message> install() {
        ArrayList<Message> msgs = new ArrayList<Message>();
        RemoteRepositoryManager manager = new RemoteRepositoryManager(this.sesameUrl);
        try {
            manager.initialize();
            msgs.add((Message)Notifications.success((String)"Connecting to Sesame Server..."));
            if (!manager.hasRepositoryConfig(this.sesameDbName)) {
                msgs.add((Message)Notifications.success((String)"Retrieving Sesame databases..."));
                RepositoryConfig config = new RepositoryConfig(this.sesameDbName, "StreamPipes DB");
                MemoryStoreConfig backendConfig = new MemoryStoreConfig(true, 10000L);
                backendConfig = new ForwardChainingRDFSInferencerConfig((SailImplConfig)backendConfig);
                config.setRepositoryImplConfig((RepositoryImplConfig)new SailRepositoryConfig((SailImplConfig)backendConfig));
                manager.addRepositoryConfig(config);
                msgs.add((Message)Notifications.success((String)this.getTitle()));
                boolean success = StorageManager.INSTANCE.getBackgroundKnowledgeStorage().initialize();
                if (success) {
                    msgs.add((Message)Notifications.success((String)"Adding schema..."));
                } else {
                    msgs.add((Message)Notifications.error((String)"Adding schema..."));
                }
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return Arrays.asList(Notifications.error((String)"Connecting to Sesame Server..."));
        }
        catch (RepositoryConfigException e) {
            return Arrays.asList(Notifications.error((String)"Retrieving Sesame databases..."));
        }
        return msgs;
    }

    @Override
    public String getTitle() {
        return "Creating Sesame database...";
    }
}

