/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.setup;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.streampipes.manager.setup.InstallationStep;
import org.streampipes.model.client.messages.Message;
import org.streampipes.model.client.messages.Notifications;
import org.streampipes.model.client.user.Role;
import org.streampipes.model.client.user.User;
import org.streampipes.storage.management.StorageDispatcher;
import org.streampipes.user.management.util.PasswordUtil;

public class UserRegistrationInstallationStep
implements InstallationStep {
    private String adminEmail;
    private String adminPassword;
    private Set<Role> roles;

    public UserRegistrationInstallationStep(String adminEmail, String adminPassword) {
        this.adminEmail = adminEmail;
        this.adminPassword = adminPassword;
        this.roles = new HashSet<Role>();
        this.roles.add(Role.SYSTEM_ADMINISTRATOR);
        this.roles.add(Role.USER_DEMO);
    }

    @Override
    public List<Message> install() {
        try {
            String encryptedPassword = PasswordUtil.encryptPassword((String)this.adminPassword);
            StorageDispatcher.INSTANCE.getNoSqlStore().getUserStorageAPI().storeUser(new User(this.adminEmail, encryptedPassword, this.roles));
            return Arrays.asList(Notifications.success((String)this.getTitle()));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
            return Arrays.asList(Notifications.error((String)"Could not encrypt password"));
        }
    }

    @Override
    public String getTitle() {
        return "Creating admin user...";
    }
}

