/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.storage;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Set;
import org.streampipes.manager.storage.UserService;
import org.streampipes.model.client.user.RegistrationData;
import org.streampipes.model.client.user.Role;
import org.streampipes.model.client.user.User;
import org.streampipes.storage.management.StorageDispatcher;
import org.streampipes.user.management.util.PasswordUtil;

public class UserManagementService {
    public Boolean registerUser(RegistrationData data, Set<Role> roles) {
        User user = new User(data.getEmail(), data.getPassword(), roles);
        try {
            String encryptedPassword = PasswordUtil.encryptPassword((String)data.getPassword());
            user.setPassword(encryptedPassword);
            StorageDispatcher.INSTANCE.getNoSqlStore().getUserStorageAPI().storeUser(user);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            return false;
        }
        return true;
    }

    public static UserService getUserService() {
        return new UserService(StorageDispatcher.INSTANCE.getNoSqlStore().getUserStorageAPI());
    }
}

