/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.lightcouch.CouchDbClient;
import org.streampipes.commons.exceptions.ElementNotFoundException;
import org.streampipes.model.client.pipeline.Pipeline;
import org.streampipes.model.client.user.User;
import org.streampipes.storage.api.INoSqlStorage;
import org.streampipes.storage.api.IUserStorage;
import org.streampipes.storage.couchdb.utils.Utils;
import org.streampipes.storage.management.StorageDispatcher;

public class UserService {
    private IUserStorage userStorage;

    public UserService(IUserStorage userStorage) {
        this.userStorage = userStorage;
    }

    public List<Pipeline> getPublicPipelines(String username) {
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>();
        this.userStorage().getAllUsers().stream().map(u -> u.getPipelines().stream().filter(p -> p.isPublicElement()).collect(Collectors.toList())).forEach(pipelines::addAll);
        return pipelines;
    }

    public List<Pipeline> getOwnPipelines(String email) {
        return StorageDispatcher.INSTANCE.getNoSqlStore().getPipelineStorageAPI().getAllPipelines().stream().filter(p -> p.getCreatedByUser().equals(email)).collect(Collectors.toList());
    }

    public Pipeline getPipeline(String username, String pipelineId) throws ElementNotFoundException {
        return StorageDispatcher.INSTANCE.getNoSqlStore().getPipelineStorageAPI().getAllPipelines().stream().filter(p -> p.getPipelineId().equals(pipelineId)).findFirst().orElseThrow(ElementNotFoundException::new);
    }

    public void addOwnPipeline(String username, Pipeline pipeline) {
        if (!this.checkUser(username)) {
            return;
        }
        StorageDispatcher.INSTANCE.getNoSqlStore().getPipelineStorageAPI().storePipeline(pipeline);
    }

    public void addOwnSource(String username, String elementId, boolean publicElement) {
        if (!this.checkUser(username)) {
            return;
        }
        User user = this.userStorage.getUser(username);
        user.addOwnSource(elementId, publicElement);
        this.userStorage.updateUser(user);
    }

    public void addOwnAction(String username, String elementId, boolean publicElement) {
        if (!this.checkUser(username)) {
            return;
        }
        User user = this.userStorage.getUser(username);
        user.addOwnAction(elementId, publicElement);
        this.userStorage.updateUser(user);
    }

    public void addOwnSepa(String username, String elementId, boolean publicElement) {
        if (!this.checkUser(username)) {
            return;
        }
        User user = this.userStorage.getUser(username);
        user.addOwnSepa(elementId, publicElement);
        this.userStorage.updateUser(user);
    }

    public void deleteOwnPipeline(String username, String pipelineId) {
        if (this.checkUser(username)) {
            User user = this.userStorage.getUser(username);
            user.deletePipeline(pipelineId);
            this.userStorage.updateUser(user);
        }
    }

    public void deleteOwnAction(String username, String actionId) {
        if (this.checkUser(username)) {
            User user = this.userStorage.getUser(username);
            user.getOwnActions().removeIf(a -> a.getElementId().equals(actionId));
            this.userStorage.updateUser(user);
        }
    }

    public void deleteOwnSource(String username, String sourceId) {
        if (this.checkUser(username)) {
            User user = this.userStorage.getUser(username);
            user.getOwnSources().removeIf(a -> a.getElementId().equals(sourceId));
            this.userStorage.updateUser(user);
        }
    }

    public void deleteOwnSepa(String username, String sepaId) {
        if (this.checkUser(username)) {
            User user = this.userStorage.getUser(username);
            user.getOwnSepas().removeIf(a -> a.getElementId().equals(sepaId));
            this.userStorage.updateUser(user);
        }
    }

    public void addSepaAsFavorite(String username, String elementId) {
        if (!this.checkUser(username)) {
            return;
        }
        User user = this.userStorage.getUser(username);
        user.addPreferredSepa(elementId);
        this.userStorage.updateUser(user);
    }

    public void addActionAsFavorite(String username, String elementId) {
        if (!this.checkUser(username)) {
            return;
        }
        User user = this.userStorage.getUser(username);
        user.addPreferredAction(elementId);
        this.userStorage.updateUser(user);
    }

    public void addSourceAsFavorite(String username, String elementId) {
        if (!this.checkUser(username)) {
            return;
        }
        User user = this.userStorage.getUser(username);
        user.addPreferredSource(elementId);
        this.userStorage.updateUser(user);
    }

    public void removeSepaFromFavorites(String username, String elementId) {
        CouchDbClient dbClient = Utils.getCouchDbUserClient();
        if (!this.checkUser(username)) {
            return;
        }
        User user = this.userStorage.getUser(username);
        user.removePreferredSepa(elementId);
        dbClient.update((Object)user);
        dbClient.shutdown();
    }

    public void removeActionFromFavorites(String username, String elementId) {
        CouchDbClient dbClient = Utils.getCouchDbUserClient();
        if (!this.checkUser(username)) {
            return;
        }
        User user = this.userStorage.getUser(username);
        user.removePreferredAction(elementId);
        dbClient.update((Object)user);
        dbClient.shutdown();
    }

    public void removeSourceFromFavorites(String username, String elementId) {
        CouchDbClient dbClient = Utils.getCouchDbUserClient();
        if (!this.checkUser(username)) {
            return;
        }
        User user = this.userStorage.getUser(username);
        user.removePreferredSource(elementId);
        dbClient.update((Object)user);
        dbClient.shutdown();
    }

    public List<String> getOwnActionUris(String username) {
        return this.userStorage.getUser(username).getOwnActions().stream().map(r -> r.getElementId()).collect(Collectors.toList());
    }

    public List<String> getFavoriteActionUris(String username) {
        return this.userStorage.getUser(username).getPreferredActions();
    }

    public List<String> getAvailableActionUris(String email) {
        ArrayList<String> actions = new ArrayList<String>(this.getOwnActionUris(email));
        this.userStorage.getAllUsers().stream().filter(u -> !u.getEmail().equals(email)).map(u -> u.getOwnActions().stream().filter(p -> p.isPublicElement()).map(p -> p.getElementId()).collect(Collectors.toList())).forEach(actions::addAll);
        return actions;
    }

    public List<String> getOwnSepaUris(String email) {
        return this.userStorage.getUser(email).getOwnSepas().stream().map(r -> r.getElementId()).collect(Collectors.toList());
    }

    public List<String> getAvailableSepaUris(String email) {
        ArrayList<String> sepas = new ArrayList<String>(this.getOwnSepaUris(email));
        this.userStorage.getAllUsers().stream().filter(u -> !u.getEmail().equals(email)).map(u -> u.getOwnSepas().stream().filter(p -> p.isPublicElement()).map(p -> p.getElementId()).collect(Collectors.toList())).forEach(sepas::addAll);
        return sepas;
    }

    public List<String> getFavoriteSepaUris(String email) {
        return this.userStorage.getUser(email).getPreferredSepas();
    }

    public List<String> getOwnSourceUris(String email) {
        return this.userStorage.getUser(email).getOwnSources().stream().map(r -> r.getElementId()).collect(Collectors.toList());
    }

    public List<String> getAvailableSourceUris(String email) {
        ArrayList<String> sources = new ArrayList<String>(this.getOwnSepaUris(email));
        this.userStorage.getAllUsers().stream().filter(u -> !u.getEmail().equals(email)).map(u -> u.getOwnSources().stream().filter(p -> p.isPublicElement()).map(p -> p.getElementId()).collect(Collectors.toList())).forEach(sources::addAll);
        return sources;
    }

    public List<String> getFavoriteSourceUris(String username) {
        return this.userStorage.getUser(username).getPreferredSources();
    }

    private IUserStorage userStorage() {
        return this.getStorageManager().getUserStorageAPI();
    }

    public boolean checkUser(String username) {
        return this.userStorage.checkUser(username);
    }

    private INoSqlStorage getStorageManager() {
        return StorageDispatcher.INSTANCE.getNoSqlStore();
    }
}

