/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.streampipes.commons.exceptions.NoSepaInPipelineException;
import org.streampipes.manager.matching.DataSetGroundingSelector;
import org.streampipes.manager.matching.PipelineVerificationHandler;
import org.streampipes.model.SpDataSet;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.client.exception.InvalidConnectionException;
import org.streampipes.model.client.pipeline.DataSetModificationMessage;
import org.streampipes.model.client.pipeline.Pipeline;
import org.streampipes.model.client.pipeline.PipelineModification;
import org.streampipes.model.client.pipeline.PipelineModificationMessage;
import org.streampipes.model.graph.DataProcessorInvocation;
import org.streampipes.model.graph.DataSinkInvocation;
import org.streampipes.model.template.BoundPipelineElement;
import org.streampipes.model.template.PipelineTemplateDescription;
import org.streampipes.storage.management.StorageDispatcher;

public class PipelineGenerator {
    private PipelineTemplateDescription pipelineTemplateDescription;
    private String datasetId;
    private Pipeline pipeline;
    private String pipelineName;
    private int count = 0;

    public PipelineGenerator(String datasetId, PipelineTemplateDescription pipelineTemplateDescription, String pipelineName) {
        this.pipelineTemplateDescription = pipelineTemplateDescription;
        this.datasetId = datasetId;
        this.pipelineName = pipelineName;
        this.pipeline = new Pipeline();
    }

    public Pipeline makePipeline() {
        this.pipeline.setName(this.pipelineName);
        this.pipeline.setPipelineId(UUID.randomUUID().toString());
        this.pipeline.setStreams(Collections.singletonList(this.prepareStream(this.datasetId)));
        this.pipeline.setSepas(new ArrayList());
        this.pipeline.setActions(new ArrayList());
        this.collectInvocations("domId" + this.count, this.pipelineTemplateDescription.getBoundTo());
        return this.pipeline;
    }

    private SpDataStream prepareStream(String streamId) {
        SpDataStream stream = this.getStream(streamId);
        if (stream instanceof SpDataSet) {
            stream = new SpDataSet((SpDataSet)stream);
            DataSetModificationMessage message = new DataSetGroundingSelector((SpDataSet)stream).selectGrounding();
            stream.setEventGrounding(message.getEventGrounding());
            ((SpDataSet)stream).setDatasetInvocationId(message.getInvocationId());
        } else {
            stream = new SpDataStream(stream);
        }
        stream.setDOM(this.getDom());
        return stream;
    }

    private void collectInvocations(String currentDomId, List<BoundPipelineElement> boundPipelineElements) {
        for (BoundPipelineElement pipelineElement : boundPipelineElements) {
            PipelineModificationMessage message;
            InvocableStreamPipesEntity entity = this.clonePe(pipelineElement.getPipelineElementTemplate());
            entity.setConnectedTo(Collections.singletonList(currentDomId));
            entity.setDOM(this.getDom());
            if (entity instanceof DataProcessorInvocation) {
                this.pipeline.getSepas().add((DataProcessorInvocation)entity);
                try {
                    message = new PipelineVerificationHandler(this.pipeline).validateConnection().computeMappingProperties().getPipelineModificationMessage();
                    this.pipeline.getSepas().remove(entity);
                    entity.setConfigured(true);
                    entity.setStaticProperties(((PipelineModification)message.getPipelineModifications().get(0)).getStaticProperties());
                    this.pipeline.getSepas().add((DataProcessorInvocation)entity);
                }
                catch (NoSepaInPipelineException | InvalidConnectionException e) {
                    e.printStackTrace();
                }
                if (pipelineElement.getConnectedTo().size() <= 0) continue;
                this.collectInvocations(entity.getDOM(), pipelineElement.getConnectedTo());
                continue;
            }
            this.pipeline.getActions().add((DataSinkInvocation)entity);
            try {
                message = new PipelineVerificationHandler(this.pipeline).validateConnection().computeMappingProperties().getPipelineModificationMessage();
                this.pipeline.getActions().remove(entity);
                entity.setConfigured(true);
                entity.setStaticProperties(((PipelineModification)message.getPipelineModifications().get(0)).getStaticProperties());
                this.pipeline.getActions().add((DataSinkInvocation)entity);
            }
            catch (NoSepaInPipelineException | InvalidConnectionException e) {
                e.printStackTrace();
            }
        }
    }

    private InvocableStreamPipesEntity clonePe(InvocableStreamPipesEntity pipelineElementTemplate) {
        if (pipelineElementTemplate instanceof DataProcessorInvocation) {
            return new DataProcessorInvocation((DataProcessorInvocation)pipelineElementTemplate);
        }
        return new DataSinkInvocation((DataSinkInvocation)pipelineElementTemplate);
    }

    private SpDataStream getStream(String datasetId) {
        return StorageDispatcher.INSTANCE.getTripleStore().getStorageAPI().getEventStreamById(datasetId);
    }

    private String getDom() {
        ++this.count;
        return "domId" + this.count;
    }
}

