/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.template;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.commons.exceptions.ElementNotFoundException;
import org.streampipes.manager.matching.DataSetGroundingSelector;
import org.streampipes.manager.matching.v2.ElementVerification;
import org.streampipes.manager.template.instances.DashboardPipelineTemplate;
import org.streampipes.manager.template.instances.DataLakePipelineTemplate;
import org.streampipes.manager.template.instances.ElasticsearchPipelineTemplate;
import org.streampipes.manager.template.instances.FilterElasticSearchPipelineTemplate;
import org.streampipes.manager.template.instances.FilterPipelineTemplate;
import org.streampipes.manager.template.instances.PipelineTemplate;
import org.streampipes.model.SpDataSet;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.client.pipeline.DataSetModificationMessage;
import org.streampipes.model.graph.DataProcessorDescription;
import org.streampipes.model.graph.DataProcessorInvocation;
import org.streampipes.model.graph.DataSinkDescription;
import org.streampipes.model.graph.DataSinkInvocation;
import org.streampipes.model.template.BoundPipelineElement;
import org.streampipes.model.template.PipelineTemplateDescription;
import org.streampipes.storage.api.IPipelineElementDescriptionStorage;
import org.streampipes.storage.management.StorageDispatcher;

public class PipelineTemplateGenerator {
    Logger logger = LoggerFactory.getLogger(PipelineTemplateGenerator.class);
    private List<PipelineTemplateDescription> availableDescriptions = new ArrayList<PipelineTemplateDescription>();

    public List<PipelineTemplateDescription> getAllPipelineTemplates() {
        ArrayList<PipelineTemplateGenerator> allPipelineTemplates = new ArrayList<PipelineTemplateGenerator>();
        allPipelineTemplates.add(new DashboardPipelineTemplate());
        allPipelineTemplates.add(new ElasticsearchPipelineTemplate());
        allPipelineTemplates.add(new DataLakePipelineTemplate());
        allPipelineTemplates.add(new FilterPipelineTemplate());
        allPipelineTemplates.add(new FilterElasticSearchPipelineTemplate());
        for (PipelineTemplate pipelineTemplate : allPipelineTemplates) {
            try {
                this.availableDescriptions.add(pipelineTemplate.declareModel());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (ElementNotFoundException e) {
                this.logger.warn("Adapter template can not be used because some elements are not installed", (Throwable)e);
            }
        }
        return this.availableDescriptions;
    }

    public List<PipelineTemplateDescription> getCompatibleTemplates(String streamId) {
        ArrayList<PipelineTemplateDescription> compatibleTemplates = new ArrayList<PipelineTemplateDescription>();
        ElementVerification verifier = new ElementVerification();
        Object streamOffer = null;
        try {
            streamOffer = this.getStream(streamId);
            streamOffer = streamOffer instanceof SpDataSet ? new SpDataSet((SpDataSet)this.prepareStream((SpDataSet)streamOffer)) : new SpDataStream(streamOffer);
            if (streamOffer != null) {
                for (PipelineTemplateDescription pipelineTemplateDescription : this.getAllPipelineTemplates()) {
                    InvocableStreamPipesEntity entity = this.cloneInvocation(((BoundPipelineElement)pipelineTemplateDescription.getBoundTo().get(0)).getPipelineElementTemplate());
                    if (!verifier.verify((SpDataStream)streamOffer, entity)) continue;
                    compatibleTemplates.add(pipelineTemplateDescription);
                }
            }
        }
        catch (ElementNotFoundException e) {
            e.printStackTrace();
        }
        return compatibleTemplates;
    }

    private InvocableStreamPipesEntity cloneInvocation(InvocableStreamPipesEntity pipelineElementTemplate) {
        if (pipelineElementTemplate instanceof DataProcessorInvocation) {
            return new DataProcessorInvocation((DataProcessorInvocation)pipelineElementTemplate);
        }
        return new DataSinkInvocation((DataSinkInvocation)pipelineElementTemplate);
    }

    private SpDataStream prepareStream(SpDataSet stream) {
        DataSetModificationMessage message = new DataSetGroundingSelector(stream).selectGrounding();
        stream.setEventGrounding(message.getEventGrounding());
        stream.setDatasetInvocationId(message.getInvocationId());
        return stream;
    }

    protected SpDataStream getStream(String streamId) throws ElementNotFoundException {
        SpDataStream result = this.getStorage().getEventStreamById(streamId);
        if (result == null) {
            throw new ElementNotFoundException("Data stream " + streamId + " is not installed!");
        }
        return result;
    }

    protected DataProcessorDescription getProcessor(String id) throws URISyntaxException, ElementNotFoundException {
        DataProcessorDescription result = this.getStorage().getSEPAByAppId(id);
        if (result == null) {
            throw new ElementNotFoundException("Data processor " + id + " is not installed!");
        }
        return result;
    }

    protected DataSinkDescription getSink(String id) throws URISyntaxException, ElementNotFoundException {
        DataSinkDescription result = this.getStorage().getSECByAppId(id);
        if (result == null) {
            throw new ElementNotFoundException("Data stream " + id + " is not installed!");
        }
        return result;
    }

    protected IPipelineElementDescriptionStorage getStorage() {
        return StorageDispatcher.INSTANCE.getTripleStore().getStorageAPI();
    }
}

