/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.template;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.streampipes.manager.template.PipelineGenerator;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.client.pipeline.Pipeline;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.template.PipelineTemplateDescription;
import org.streampipes.model.template.PipelineTemplateInvocation;

public class PipelineTemplateInvocationGenerator {
    private SpDataStream spDataStream;
    private PipelineTemplateDescription pipelineTemplateDescription;

    public PipelineTemplateInvocationGenerator(SpDataStream dataStream, PipelineTemplateDescription pipelineTemplateDescription) {
        this.spDataStream = dataStream;
        this.pipelineTemplateDescription = pipelineTemplateDescription;
    }

    public PipelineTemplateInvocation generateInvocation() {
        Pipeline pipeline = new PipelineGenerator(this.spDataStream.getElementId(), this.pipelineTemplateDescription, "test").makePipeline();
        PipelineTemplateInvocation pipelineTemplateInvocation = new PipelineTemplateInvocation();
        pipelineTemplateInvocation.setStaticProperties(this.collectStaticProperties(pipeline));
        pipelineTemplateInvocation.setDataSetId(this.spDataStream.getElementId());
        pipelineTemplateInvocation.setPipelineTemplateId(this.pipelineTemplateDescription.getPipelineTemplateId());
        return pipelineTemplateInvocation;
    }

    private List<StaticProperty> collectStaticProperties(Pipeline pipeline) {
        ArrayList<StaticProperty> staticProperties = new ArrayList<StaticProperty>();
        pipeline.getSepas().forEach(pe -> {
            pe.getStaticProperties().forEach(sp -> sp.setInternalName(pe.getDOM() + sp.getInternalName()));
            staticProperties.addAll(pe.getStaticProperties());
        });
        pipeline.getActions().forEach(pe -> {
            pe.getStaticProperties().forEach(sp -> sp.setInternalName(pe.getDOM() + sp.getInternalName()));
            staticProperties.addAll(pe.getStaticProperties());
        });
        return staticProperties;
    }

    private List<StaticProperty> filter(List<StaticProperty> staticProperties) {
        return staticProperties.stream().filter((? super T sp) -> !sp.isPredefined()).collect(Collectors.toList());
    }
}

