/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.template;

import java.util.ArrayList;
import org.streampipes.manager.operations.Operations;
import org.streampipes.manager.template.PipelineGenerator;
import org.streampipes.manager.template.PipelineTemplateGenerator;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.client.pipeline.Pipeline;
import org.streampipes.model.client.pipeline.PipelineOperationStatus;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.template.PipelineTemplateDescription;
import org.streampipes.model.template.PipelineTemplateInvocation;
import org.streampipes.storage.management.StorageDispatcher;

public class PipelineTemplateInvocationHandler {
    private PipelineTemplateInvocation pipelineTemplateInvocation;
    private PipelineTemplateDescription pipelineTemplateDescription;
    private String username;

    public PipelineTemplateInvocationHandler(String username, PipelineTemplateInvocation pipelineTemplateInvocation) {
        this.username = username;
        this.pipelineTemplateInvocation = pipelineTemplateInvocation;
        this.pipelineTemplateDescription = this.getTemplateById(pipelineTemplateInvocation.getPipelineTemplateId());
    }

    public PipelineTemplateInvocationHandler(String username, PipelineTemplateInvocation pipelineTemplateInvocation, PipelineTemplateDescription pipelineTemplateDescription) {
        this.username = username;
        this.pipelineTemplateInvocation = pipelineTemplateInvocation;
        this.pipelineTemplateDescription = pipelineTemplateDescription;
    }

    public PipelineOperationStatus handlePipelineInvocation() {
        Pipeline pipeline = new PipelineGenerator(this.pipelineTemplateInvocation.getDataSetId(), this.pipelineTemplateDescription, this.pipelineTemplateInvocation.getKviName()).makePipeline();
        pipeline.setCreatedByUser(this.username);
        pipeline.setCreatedAt(System.currentTimeMillis());
        this.replaceStaticProperties(pipeline);
        Operations.storePipeline(pipeline);
        Pipeline storedPipeline = StorageDispatcher.INSTANCE.getNoSqlStore().getPipelineStorageAPI().getPipeline(pipeline.getPipelineId());
        return Operations.startPipeline(storedPipeline);
    }

    private void replaceStaticProperties(Pipeline pipeline) {
        pipeline.getSepas().forEach(this::replace);
        pipeline.getActions().forEach(this::replace);
    }

    private void replace(InvocableStreamPipesEntity pe) {
        ArrayList newProperties = new ArrayList();
        pe.getStaticProperties().forEach(sp -> {
            if (this.existsInCustomizedElements(pe.getDOM(), (StaticProperty)sp)) {
                newProperties.add(this.getCustomizedElement(pe.getDOM(), pe.getDOM() + sp.getInternalName()));
            } else {
                newProperties.add(sp);
            }
        });
        pe.setStaticProperties(newProperties);
    }

    private StaticProperty getCustomizedElement(String dom, String internalName) {
        StaticProperty staticProperty = this.pipelineTemplateInvocation.getStaticProperties().stream().filter(sp -> sp.getInternalName().equals(internalName)).findFirst().get();
        staticProperty.setInternalName(staticProperty.getInternalName().replace(dom, ""));
        return staticProperty;
    }

    private boolean existsInCustomizedElements(String dom, StaticProperty staticProperty) {
        return this.pipelineTemplateInvocation.getStaticProperties().stream().anyMatch(sp -> sp.getInternalName().equals(dom + staticProperty.getInternalName()));
    }

    private PipelineTemplateDescription getTemplateById(String pipelineTemplateId) {
        return new PipelineTemplateGenerator().getAllPipelineTemplates().stream().filter(template -> template.getAppId().equals(pipelineTemplateId)).findFirst().get();
    }
}

