/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.topic;

import java.util.List;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.grounding.TopicDefinition;
import org.streampipes.model.grounding.TopicParameterType;
import org.streampipes.model.grounding.WildcardTopicDefinition;
import org.streampipes.model.grounding.WildcardTopicMapping;

public class WildcardTopicGenerator {
    private SpDataStream stream;

    public WildcardTopicGenerator(SpDataStream stream) {
        this.stream = stream;
    }

    public SpDataStream computeActualTopic() {
        TopicDefinition topicDefinition = this.stream.getEventGrounding().getTransportProtocol().getTopicDefinition();
        if (topicDefinition instanceof WildcardTopicDefinition) {
            WildcardTopicDefinition wildcardTopicDefinition = (WildcardTopicDefinition)topicDefinition;
            String actualTopicName = this.buildActualTopicName(wildcardTopicDefinition.getWildcardTopicName(), wildcardTopicDefinition.getWildcardTopicMappings());
            wildcardTopicDefinition.setActualTopicName(actualTopicName);
            this.stream.getEventGrounding().getTransportProtocol().setTopicDefinition((TopicDefinition)wildcardTopicDefinition);
        }
        return this.stream;
    }

    private String buildActualTopicName(String wildcardTopicName, List<WildcardTopicMapping> wildcardTopicMappings) {
        for (WildcardTopicMapping wm : wildcardTopicMappings) {
            if (TopicParameterType.valueOf((String)wm.getTopicParameterType()) == TopicParameterType.SENSOR_TYPE || TopicParameterType.valueOf((String)wm.getTopicParameterType()) == TopicParameterType.PLATFORM_TYPE) {
                wm.setSelectedMapping(wm.getMappingId());
            }
            wildcardTopicName = wildcardTopicName.replace("$" + wm.getMappingId(), wm.getSelectedMapping());
        }
        return wildcardTopicName;
    }
}

