/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.verification;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.streampipes.commons.exceptions.SepaParseException;
import org.streampipes.manager.storage.UserManagementService;
import org.streampipes.manager.storage.UserService;
import org.streampipes.manager.verification.StorageState;
import org.streampipes.manager.verification.messages.VerificationError;
import org.streampipes.manager.verification.messages.VerificationResult;
import org.streampipes.manager.verification.structure.GeneralVerifier;
import org.streampipes.manager.verification.structure.Verifier;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.client.messages.ErrorMessage;
import org.streampipes.model.client.messages.Message;
import org.streampipes.model.client.messages.Notification;
import org.streampipes.model.client.messages.NotificationType;
import org.streampipes.model.client.messages.SuccessMessage;
import org.streampipes.serializers.jsonld.JsonLdTransformer;
import org.streampipes.storage.api.IPipelineElementDescriptionStorage;
import org.streampipes.storage.management.StorageManager;

public abstract class ElementVerifier<T extends NamedStreamPipesEntity> {
    protected static final Logger logger = Logger.getAnonymousLogger();
    private String graphData;
    private Class<T> elementClass;
    protected T elementDescription;
    protected List<VerificationResult> validationResults;
    protected List<Verifier> validators;
    protected IPipelineElementDescriptionStorage storageApi = StorageManager.INSTANCE.getStorageAPI();
    protected UserService userService = UserManagementService.getUserService();

    public ElementVerifier(String graphData, Class<T> elementClass) {
        this.elementClass = elementClass;
        this.graphData = graphData;
        this.validators = new ArrayList<Verifier>();
        this.validationResults = new ArrayList<VerificationResult>();
    }

    protected void collectValidators() {
        this.validators.add(new GeneralVerifier<T>(this.elementDescription));
    }

    protected abstract StorageState store(String var1, boolean var2);

    protected abstract void update(String var1);

    protected void verify() {
        this.collectValidators();
        this.validators.forEach(validator -> this.validationResults.addAll(validator.validate()));
    }

    public Message verifyAndAdd(String username, boolean publicElement) throws SepaParseException {
        try {
            this.elementDescription = this.transform();
        }
        catch (IOException | RepositoryException | RDFParseException | UnsupportedRDFormatException e) {
            return new ErrorMessage(new Notification[]{NotificationType.UNKNOWN_ERROR.uiNotification()});
        }
        this.verify();
        if (this.isVerifiedSuccessfully()) {
            StorageState state = this.store(username, publicElement);
            if (state == StorageState.STORED) {
                try {
                    this.storeAssets();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return this.successMessage();
            }
            if (state == StorageState.ALREADY_IN_SESAME) {
                return this.addedToUserSuccessMessage();
            }
            return this.skippedSuccessMessage();
        }
        return this.errorMessage();
    }

    public Message verifyAndUpdate(String username) throws SepaParseException {
        try {
            this.elementDescription = this.transform();
        }
        catch (IOException | RepositoryException | RDFParseException | UnsupportedRDFormatException e) {
            return new ErrorMessage(new Notification[]{NotificationType.UNKNOWN_ERROR.uiNotification()});
        }
        this.verify();
        if (this.isVerifiedSuccessfully()) {
            this.update(username);
            try {
                this.updateAssets();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.successMessage();
        }
        return this.errorMessage();
    }

    protected abstract void storeAssets() throws IOException;

    protected abstract void updateAssets() throws IOException;

    private Message errorMessage() {
        return new ErrorMessage(this.elementDescription.getName(), this.collectNotifications());
    }

    private Message successMessage() {
        List<Notification> notifications = this.collectNotifications();
        notifications.add(NotificationType.STORAGE_SUCCESS.uiNotification());
        return new SuccessMessage(this.elementDescription.getName(), notifications);
    }

    private Message skippedSuccessMessage() {
        List<Notification> notifications = this.collectNotifications();
        notifications.add(new Notification("Already exists", "This element is already in your list of elements, skipped."));
        return new SuccessMessage(this.elementDescription.getName(), notifications);
    }

    private Message addedToUserSuccessMessage() {
        List<Notification> notifications = this.collectNotifications();
        notifications.add(new Notification("Already stored", "Element description already stored, added element to user"));
        return new SuccessMessage(this.elementDescription.getName(), notifications);
    }

    private List<Notification> collectNotifications() {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        this.validationResults.forEach(vr -> notifications.add(vr.getNotification()));
        return notifications;
    }

    private boolean isVerifiedSuccessfully() {
        return !this.validationResults.stream().anyMatch(validator -> validator instanceof VerificationError);
    }

    protected T transform() throws RDFParseException, UnsupportedRDFormatException, RepositoryException, IOException {
        return (T)((NamedStreamPipesEntity)new JsonLdTransformer().fromJsonLd(this.graphData, this.elementClass));
    }
}

