/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.verification;

import java.io.IOException;
import org.streampipes.commons.exceptions.SepaParseException;
import org.streampipes.manager.assets.AssetManager;
import org.streampipes.manager.verification.ElementVerifier;
import org.streampipes.manager.verification.StorageState;
import org.streampipes.model.graph.DataSinkDescription;

public class SecVerifier
extends ElementVerifier<DataSinkDescription> {
    public SecVerifier(String graphData) throws SepaParseException {
        super(graphData, DataSinkDescription.class);
    }

    @Override
    protected StorageState store(String username, boolean publicElement) {
        StorageState storageState = StorageState.STORED;
        if (!this.storageApi.exists((DataSinkDescription)this.elementDescription)) {
            this.storageApi.storeSEC((DataSinkDescription)this.elementDescription);
        } else {
            storageState = StorageState.ALREADY_IN_SESAME;
        }
        if (!this.userService.getOwnActionUris(username).contains(((DataSinkDescription)this.elementDescription).getUri())) {
            this.userService.addOwnAction(username, ((DataSinkDescription)this.elementDescription).getUri(), publicElement);
        } else {
            storageState = StorageState.ALREADY_IN_SESAME_AND_USER_DB;
        }
        return storageState;
    }

    @Override
    protected void collectValidators() {
        super.collectValidators();
    }

    @Override
    protected void update(String username) {
        this.storageApi.update((DataSinkDescription)this.elementDescription);
    }

    @Override
    protected void storeAssets() throws IOException {
        if (((DataSinkDescription)this.elementDescription).isIncludesAssets()) {
            AssetManager.storeAsset(((DataSinkDescription)this.elementDescription).getElementId(), ((DataSinkDescription)this.elementDescription).getAppId());
        }
    }

    @Override
    protected void updateAssets() throws IOException {
        if (((DataSinkDescription)this.elementDescription).isIncludesAssets()) {
            AssetManager.deleteAsset(((DataSinkDescription)this.elementDescription).getAppId());
            this.storeAssets();
        }
    }
}

