/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.verification;

import java.io.IOException;
import org.streampipes.commons.exceptions.SepaParseException;
import org.streampipes.manager.assets.AssetManager;
import org.streampipes.manager.verification.ElementVerifier;
import org.streampipes.manager.verification.StorageState;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.graph.DataSourceDescription;

public class SepVerifier
extends ElementVerifier<DataSourceDescription> {
    public SepVerifier(String graphData) throws SepaParseException {
        super(graphData, DataSourceDescription.class);
    }

    @Override
    protected void collectValidators() {
        super.collectValidators();
    }

    @Override
    protected StorageState store(String username, boolean publicElement) {
        StorageState storageState = StorageState.STORED;
        if (!this.storageApi.exists((DataSourceDescription)this.elementDescription)) {
            this.storageApi.storeSEP((DataSourceDescription)this.elementDescription);
        } else {
            storageState = StorageState.ALREADY_IN_SESAME;
        }
        if (!this.userService.getOwnSourceUris(username).contains(((DataSourceDescription)this.elementDescription).getUri())) {
            this.userService.addOwnSource(username, ((DataSourceDescription)this.elementDescription).getUri(), publicElement);
        } else {
            storageState = StorageState.ALREADY_IN_SESAME_AND_USER_DB;
        }
        return storageState;
    }

    @Override
    protected void update(String username) {
        this.storageApi.update((DataSourceDescription)this.elementDescription);
    }

    @Override
    protected void storeAssets() throws IOException {
        for (SpDataStream stream : ((DataSourceDescription)this.elementDescription).getSpDataStreams()) {
            if (!stream.isIncludesAssets()) continue;
            AssetManager.storeAsset(stream.getElementId(), stream.getAppId());
        }
    }

    @Override
    protected void updateAssets() throws IOException {
        for (SpDataStream stream : ((DataSourceDescription)this.elementDescription).getSpDataStreams()) {
            if (!stream.isIncludesAssets()) continue;
            AssetManager.deleteAsset(((DataSourceDescription)this.elementDescription).getAppId());
            this.storeAssets();
        }
    }
}

