/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.verification;

import java.io.IOException;
import org.streampipes.commons.exceptions.SepaParseException;
import org.streampipes.manager.assets.AssetManager;
import org.streampipes.manager.verification.ElementVerifier;
import org.streampipes.manager.verification.StorageState;
import org.streampipes.model.graph.DataProcessorDescription;

public class SepaVerifier
extends ElementVerifier<DataProcessorDescription> {
    public SepaVerifier(String graphData) throws SepaParseException {
        super(graphData, DataProcessorDescription.class);
    }

    @Override
    protected void collectValidators() {
        super.collectValidators();
    }

    @Override
    protected StorageState store(String username, boolean publicElement) {
        StorageState storageState = StorageState.STORED;
        if (!this.storageApi.exists((DataProcessorDescription)this.elementDescription)) {
            this.storageApi.storeSEPA((DataProcessorDescription)this.elementDescription);
        } else {
            storageState = StorageState.ALREADY_IN_SESAME;
        }
        if (!this.userService.getOwnSepaUris(username).contains(((DataProcessorDescription)this.elementDescription).getUri())) {
            this.userService.addOwnSepa(username, ((DataProcessorDescription)this.elementDescription).getUri(), publicElement);
        } else {
            storageState = StorageState.ALREADY_IN_SESAME_AND_USER_DB;
        }
        return storageState;
    }

    @Override
    protected void update(String username) {
        this.storageApi.update((DataProcessorDescription)this.elementDescription);
    }

    @Override
    protected void storeAssets() throws IOException {
        if (((DataProcessorDescription)this.elementDescription).isIncludesAssets()) {
            AssetManager.storeAsset(((DataProcessorDescription)this.elementDescription).getElementId(), ((DataProcessorDescription)this.elementDescription).getAppId());
        }
    }

    @Override
    protected void updateAssets() throws IOException {
        if (((DataProcessorDescription)this.elementDescription).isIncludesAssets()) {
            AssetManager.deleteAsset(((DataProcessorDescription)this.elementDescription).getAppId());
            this.storeAssets();
        }
    }
}

