/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.manager.verification.extractor;

import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.streampipes.commons.exceptions.SepaParseException;
import org.streampipes.manager.verification.ElementVerifier;
import org.streampipes.manager.verification.SecVerifier;
import org.streampipes.manager.verification.SepVerifier;
import org.streampipes.manager.verification.SepaVerifier;
import org.streampipes.manager.verification.extractor.StatementBuilder;

public class TypeExtractor {
    private static final Logger logger = Logger.getAnonymousLogger();
    private String graphData;

    public TypeExtractor(String graphData) {
        this.graphData = graphData;
    }

    public ElementVerifier<?> getTypeVerifier() throws SepaParseException {
        List<Statement> typeDefinitions = this.getModel().stream().filter(stmt -> stmt.getPredicate().equals((Object)RDF.TYPE)).collect(Collectors.toList());
        typeDefinitions.forEach(typeDef -> typeDef.getObject());
        return this.getTypeDef(typeDefinitions.stream().filter(stmt -> stmt.getObject().toString().equals(TypeExtractor.ec()) || stmt.getObject().toString().equals(TypeExtractor.epa()) || stmt.getObject().toString().equals(TypeExtractor.ep())).findFirst());
    }

    private ElementVerifier<?> getTypeDef(Optional<Statement> typeStatement) throws SepaParseException {
        if (!typeStatement.isPresent()) {
            throw new SepaParseException();
        }
        Statement stmt = typeStatement.get();
        if (stmt.getObject().toString().equals(TypeExtractor.ep())) {
            logger.info("Detected type sep");
            return new SepVerifier(this.graphData);
        }
        if (stmt.getObject().toString().equals(TypeExtractor.epa())) {
            logger.info("Detected type sepa");
            return new SepaVerifier(this.graphData);
        }
        if (stmt.getObject().toString().equals(TypeExtractor.ec())) {
            logger.info("Detected type sec");
            return new SecVerifier(this.graphData);
        }
        throw new SepaParseException();
    }

    private Model getModel() throws SepaParseException {
        return StatementBuilder.extractStatements(this.graphData);
    }

    private static final String ep() {
        return "https://streampipes.org/vocabulary/v1/DataSourceDescription";
    }

    private static final String epa() {
        return "https://streampipes.org/vocabulary/v1/DataProcessorDescription";
    }

    private static final String ec() {
        return "https://streampipes.org/vocabulary/v1/DataSinkDescription";
    }
}

