/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.rest.shared.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.rdf4j.model.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.commons.Utils;
import org.streampipes.empire.core.empire.annotation.InvalidRdfException;
import org.streampipes.serializers.jsonld.JsonLdTransformer;

public class JsonLdUtils {
    private static final Logger logger = LoggerFactory.getLogger(JsonLdUtils.class);

    public static String toJsonLD(Object o) {
        JsonLdTransformer jsonLdTransformer = new JsonLdTransformer();
        String result = null;
        try {
            result = Utils.asString((Graph)jsonLdTransformer.toJsonLd(o));
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException | InvalidRdfException e) {
            logger.error("Could not serialize JsonLd", e);
        }
        return result;
    }

    public static <T> T fromJsonLd(String json, Class<T> clazz) {
        JsonLdTransformer jsonLdTransformer = new JsonLdTransformer();
        try {
            return (T)jsonLdTransformer.fromJsonLd(json, clazz);
        }
        catch (IOException e) {
            logger.error("Could not deserialize JsonLd", (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJsonLd(String json, Class<T> clazz, String topElement) {
        JsonLdTransformer jsonLdTransformer = new JsonLdTransformer(topElement);
        try {
            return (T)jsonLdTransformer.fromJsonLd(json, clazz);
        }
        catch (IOException e) {
            logger.error("Could not deserialize JsonLd", (Throwable)e);
            return null;
        }
    }
}

