/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.streampipes.model.SpDataSet;
import org.streampipes.model.grounding.EventGrounding;
import org.streampipes.model.grounding.TransportFormat;
import org.streampipes.model.grounding.TransportProtocol;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventSchema;
import org.streampipes.sdk.builder.AbstractPipelineElementBuilder;

public class DataSetBuilder
extends AbstractPipelineElementBuilder<DataSetBuilder, SpDataSet> {
    protected EventGrounding supportedGrounding;
    private List<EventProperty> eventProperties = new ArrayList<EventProperty>();

    protected DataSetBuilder(String id, String label, String description) {
        super(id, label, description, new SpDataSet());
        this.supportedGrounding = new EventGrounding();
    }

    public static DataSetBuilder create(String id, String label, String description) {
        return new DataSetBuilder(id, label, description);
    }

    public DataSetBuilder property(EventProperty property) {
        this.eventProperties.add(property);
        return this.me();
    }

    public DataSetBuilder supportedProtocol(TransportProtocol protocol) {
        this.supportedGrounding.setTransportProtocol(protocol);
        return this;
    }

    public DataSetBuilder supportedFormat(TransportFormat format) {
        this.supportedGrounding.setTransportFormats(Collections.singletonList(format));
        return this;
    }

    @Override
    protected DataSetBuilder me() {
        return this;
    }

    @Override
    protected void prepareBuild() {
        ((SpDataSet)this.elementDescription).setSupportedGrounding(this.supportedGrounding);
        ((SpDataSet)this.elementDescription).setEventSchema(new EventSchema(this.eventProperties));
    }
}

