/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.streampipes.model.DataProcessorType;
import org.streampipes.model.graph.DataProcessorDescription;
import org.streampipes.model.output.OutputStrategy;
import org.streampipes.sdk.builder.AbstractProcessingElementBuilder;
import org.streampipes.sdk.helpers.Label;

public class ProcessingElementBuilder
extends AbstractProcessingElementBuilder<ProcessingElementBuilder, DataProcessorDescription> {
    private List<OutputStrategy> outputStrategies = new ArrayList<OutputStrategy>();

    private ProcessingElementBuilder(String id, String name, String description) {
        super(id, name, description, new DataProcessorDescription());
    }

    public static ProcessingElementBuilder create(String id, String label, String description) {
        return new ProcessingElementBuilder(id, label, description);
    }

    public static ProcessingElementBuilder create(Label label) {
        return new ProcessingElementBuilder(label.getInternalId(), label.getLabel(), label.getDescription());
    }

    public ProcessingElementBuilder outputStrategy(OutputStrategy outputStrategy) {
        this.outputStrategies.add(outputStrategy);
        return this.me();
    }

    public ProcessingElementBuilder category(DataProcessorType ... epaCategory) {
        ((DataProcessorDescription)this.elementDescription).setCategory(Arrays.stream(epaCategory).map(Enum::name).collect(Collectors.toList()));
        return this.me();
    }

    @Override
    public void prepareBuild() {
        super.prepareBuild();
        ((DataProcessorDescription)this.elementDescription).setOutputStrategies(this.outputStrategies);
    }

    @Override
    protected ProcessingElementBuilder me() {
        return this;
    }
}

