/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.builder;

import java.net.URI;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.streampipes.model.schema.EventPropertyPrimitive;
import org.streampipes.sdk.utils.Datatypes;

public class PropertyRequirementsBuilder {
    private EventPropertyPrimitive propertyReq = new EventPropertyPrimitive();

    public static PropertyRequirementsBuilder create(Datatypes propertyDatatype) {
        return new PropertyRequirementsBuilder(propertyDatatype);
    }

    public static PropertyRequirementsBuilder create() {
        return new PropertyRequirementsBuilder();
    }

    private PropertyRequirementsBuilder() {
    }

    private PropertyRequirementsBuilder(Datatypes propertyDatatype) {
        this.propertyReq.setRuntimeType(propertyDatatype.toString());
    }

    public PropertyRequirementsBuilder datatype(Datatypes propertyDatatype) {
        this.propertyReq.setRuntimeType(propertyDatatype.toString());
        return this;
    }

    public PropertyRequirementsBuilder domainPropertyReq(String ... domainProperties) {
        this.propertyReq.setDomainProperties(Arrays.stream(domainProperties).map(URI::create).collect(Collectors.toList()));
        return this;
    }

    public PropertyRequirementsBuilder measurementUnitReq(String measurementUnit) {
        this.propertyReq.setMeasurementUnit(URI.create(measurementUnit));
        return this;
    }

    public PropertyRequirementsBuilder measurementUnitPresence() {
        this.propertyReq.setMeasurementUnit(URI.create("https://streampipes.org/vocabulary/v1/Anything"));
        return this;
    }

    public EventPropertyPrimitive build() {
        return this.propertyReq;
    }
}

