/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.extractor;

import com.github.drapostolos.typeparser.TypeParser;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventPropertyList;
import org.streampipes.model.schema.EventPropertyNested;
import org.streampipes.model.schema.EventPropertyPrimitive;
import org.streampipes.model.staticproperty.CollectionStaticProperty;
import org.streampipes.model.staticproperty.DomainStaticProperty;
import org.streampipes.model.staticproperty.FreeTextStaticProperty;
import org.streampipes.model.staticproperty.MappingPropertyNary;
import org.streampipes.model.staticproperty.MappingPropertyUnary;
import org.streampipes.model.staticproperty.OneOfStaticProperty;
import org.streampipes.model.staticproperty.Option;
import org.streampipes.model.staticproperty.RuntimeResolvableOneOfStaticProperty;
import org.streampipes.model.staticproperty.SelectionStaticProperty;
import org.streampipes.model.staticproperty.StaticProperty;
import org.streampipes.model.staticproperty.SupportedProperty;

public abstract class AbstractParameterExtractor<T extends InvocableStreamPipesEntity> {
    protected T sepaElement;
    private TypeParser typeParser;

    public AbstractParameterExtractor(T sepaElement) {
        this.sepaElement = sepaElement;
        this.typeParser = TypeParser.newBuilder().build();
    }

    public String measurementUnit(String runtimeName, Integer streamIndex) {
        return ((SpDataStream)this.sepaElement.getInputStreams().get(streamIndex)).getEventSchema().getEventProperties().stream().filter(ep -> ep.getRuntimeName().equals(runtimeName)).map(ep -> (EventPropertyPrimitive)ep).findFirst().get().getMeasurementUnit().toString();
    }

    public String inputTopic(Integer streamIndex) {
        return ((SpDataStream)this.sepaElement.getInputStreams().get(streamIndex)).getEventGrounding().getTransportProtocol().getTopicDefinition().getActualTopicName();
    }

    public <V> V singleValueParameter(String internalName, Class<V> targetClass) {
        return (V)this.typeParser.parse(this.getStaticPropertyByName(internalName, FreeTextStaticProperty.class).getValue(), targetClass);
    }

    private <V, T extends SelectionStaticProperty> V selectedSingleValue(String internalName, Class<V> targetClass, Class<T> oneOfStaticProperty) {
        return (V)this.typeParser.parse(((SelectionStaticProperty)this.getStaticPropertyByName(internalName, oneOfStaticProperty)).getOptions().stream().filter(Option::isSelected).findFirst().get().getName(), targetClass);
    }

    public <V> V selectedSingleValueFromRemote(String internalName, Class<V> targetClass) {
        return this.selectedSingleValue(internalName, targetClass, RuntimeResolvableOneOfStaticProperty.class);
    }

    public <V> V selectedSingleValue(String internalName, Class<V> targetClass) {
        return this.selectedSingleValue(internalName, targetClass, OneOfStaticProperty.class);
    }

    public <V> V selectedSingleValueInternalName(String internalName, Class<V> targetClass) {
        return (V)this.typeParser.parse(this.getStaticPropertyByName(internalName, OneOfStaticProperty.class).getOptions().stream().filter(Option::isSelected).findFirst().get().getInternalName(), targetClass);
    }

    public <V> List<V> singleValueParameterFromCollection(String internalName, Class<V> targetClass) {
        CollectionStaticProperty collection = this.getStaticPropertyByName(internalName, CollectionStaticProperty.class);
        return collection.getMembers().stream().map(sp -> (FreeTextStaticProperty)sp).map(FreeTextStaticProperty::getValue).map(v -> this.typeParser.parse(v, targetClass)).collect(Collectors.toList());
    }

    public <V> List<V> selectedMultiValues(String internalName, Class<V> targetClass) {
        return this.getStaticPropertyByName(internalName, OneOfStaticProperty.class).getOptions().stream().filter(Option::isSelected).map(Option::getName).map(o -> this.typeParser.parse(o, targetClass)).collect(Collectors.toList());
    }

    private <S extends StaticProperty> S getStaticPropertyByName(String internalName, Class<S> spType) {
        return (S)((StaticProperty)spType.cast(this.getStaticPropertyByName(internalName)));
    }

    private StaticProperty getStaticPropertyByName(String name) {
        for (StaticProperty p : this.sepaElement.getStaticProperties()) {
            if (!p.getInternalName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public String mappingPropertyValue(String staticPropertyName) {
        URI propertyURI = this.getURIFromStaticProperty(staticPropertyName);
        return this.mappingPropertyValues(staticPropertyName, false, propertyURI).get(0);
    }

    public List<String> mappingPropertyValues(String staticPropertyName) {
        Optional<MappingPropertyNary> mappingPropertyOpt = this.sepaElement.getStaticProperties().stream().filter(p -> p instanceof MappingPropertyNary).map(p -> (MappingPropertyNary)p).filter(p -> p.getInternalName().equals(staticPropertyName)).findFirst();
        if (mappingPropertyOpt.isPresent()) {
            MappingPropertyNary mappingProperty = mappingPropertyOpt.get();
            ArrayList<String> result = new ArrayList<String>();
            for (Object obj : mappingProperty.getMapsTo()) {
                if (obj.getClass().isAssignableFrom(URI.class)) {
                    result.addAll(this.mappingPropertyValues(staticPropertyName, false, (URI)obj));
                    continue;
                }
                if (!(obj instanceof EventProperty)) continue;
                EventProperty property = (EventProperty)obj;
                result.add(property.getRuntimeName());
            }
            return result;
        }
        return new ArrayList<String>();
    }

    public String propertyDatatype(String runtimeName) {
        ArrayList eventProperties = new ArrayList();
        for (SpDataStream is : this.sepaElement.getInputStreams()) {
            eventProperties.addAll(is.getEventSchema().getEventProperties());
        }
        Optional<EventProperty> matchedProperty = eventProperties.stream().filter(ep -> ep.getRuntimeName().equals(runtimeName)).findFirst();
        if (matchedProperty.isPresent()) {
            EventProperty listProperty;
            EventProperty p = matchedProperty.get();
            if (p instanceof EventPropertyPrimitive) {
                return ((EventPropertyPrimitive)p).getRuntimeType();
            }
            if (p instanceof EventPropertyList && (listProperty = (EventProperty)((EventPropertyList)p).getEventProperties().get(0)) instanceof EventPropertyPrimitive) {
                return ((EventPropertyPrimitive)listProperty).getRuntimeType();
            }
        }
        return null;
    }

    public List<String> mappingPropertyValues(String staticPropertyName, boolean completeNames, URI propertyURI) {
        for (SpDataStream stream : this.sepaElement.getInputStreams()) {
            List<String> matchedProperties = this.getMappingPropertyName(stream.getEventSchema().getEventProperties(), propertyURI, completeNames, "");
            if (matchedProperties.size() <= 0) continue;
            return matchedProperties;
        }
        return null;
    }

    public <V> V supportedOntologyPropertyValue(String domainPropertyInternalId, String propertyId, Class<V> targetClass) {
        DomainStaticProperty dsp = this.getStaticPropertyByName(domainPropertyInternalId, DomainStaticProperty.class);
        return (V)this.typeParser.parse(dsp.getSupportedProperties().stream().filter(sp -> sp.getPropertyId().equals(propertyId)).findFirst().map(SupportedProperty::getValue).get(), targetClass);
    }

    private List<String> getMappingPropertyName(List<EventProperty> eventProperties, URI propertyURI, boolean completeNames, String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        for (EventProperty p : eventProperties) {
            if (p instanceof EventPropertyPrimitive || p instanceof EventPropertyList) {
                if (p.getElementId().equals(propertyURI.toString())) {
                    if (!completeNames) {
                        result.add(p.getRuntimeName());
                    } else {
                        result.add(prefix + p.getRuntimeName());
                    }
                }
                if (!(p instanceof EventPropertyList)) continue;
                for (EventProperty sp : ((EventPropertyList)p).getEventProperties()) {
                    if (!sp.getElementId().equals(propertyURI.toString())) continue;
                    result.add(p.getRuntimeName() + "," + sp.getRuntimeName());
                }
                continue;
            }
            if (!(p instanceof EventPropertyNested)) continue;
            result.addAll(this.getMappingPropertyName(((EventPropertyNested)p).getEventProperties(), propertyURI, completeNames, prefix + p.getRuntimeName() + "."));
        }
        return result;
    }

    private URI getURIFromStaticProperty(String staticPropertyName) {
        Optional<MappingPropertyUnary> property = this.sepaElement.getStaticProperties().stream().filter(p -> p instanceof MappingPropertyUnary).map(p -> (MappingPropertyUnary)p).filter(p -> p.getInternalName().equals(staticPropertyName)).findFirst();
        return property.map(MappingPropertyUnary::getMapsTo).orElse(null);
    }
}

