/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.helpers;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.streampipes.commons.Utils;
import org.streampipes.model.schema.Enumeration;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventPropertyList;
import org.streampipes.model.schema.EventPropertyNested;
import org.streampipes.model.schema.EventPropertyPrimitive;
import org.streampipes.model.schema.QuantitativeValue;
import org.streampipes.model.schema.ValueSpecification;
import org.streampipes.sdk.helpers.Label;
import org.streampipes.sdk.helpers.Labels;
import org.streampipes.sdk.utils.Datatypes;
import org.streampipes.vocabulary.XSD;

public class EpProperties {
    public static EventPropertyNested nestedEp(Label label, String runtimeName, EventProperty ... eventProperties) {
        EventPropertyNested nestedProperty = EpProperties.getPreparedProperty(label, new EventPropertyNested(runtimeName));
        nestedProperty.setEventProperties(new ArrayList<EventProperty>(Arrays.asList(eventProperties)));
        return nestedProperty;
    }

    public EventPropertyList listNestedEp(Label label, String runtimeName, EventProperty ... nestedProperties) {
        EventPropertyList list = EpProperties.getPreparedProperty(label, new EventPropertyList());
        list.setRuntimeName(runtimeName);
        EventPropertyNested nested = new EventPropertyNested();
        nested.setEventProperties(Arrays.asList(nestedProperties));
        list.setEventProperties(Collections.singletonList(nested));
        return list;
    }

    public static EventPropertyPrimitive timestampProperty(String runtimeName) {
        return EpProperties.ep(Labels.from("", "Timestamp", "The current timestamp value"), XSD._long.toString(), runtimeName, "http://schema.org/DateTime");
    }

    public static EventPropertyList listIntegerEp(Label label, String runtimeName, String domainProperty) {
        return EpProperties.listEp(label, runtimeName, Datatypes.Integer, domainProperty);
    }

    public static EventPropertyList listLongEp(Label label, String runtimeName, String domainProperty) {
        return EpProperties.listEp(label, runtimeName, Datatypes.Long, domainProperty);
    }

    public static EventPropertyList listDoubleEp(Label label, String runtimeName, String domainProperty) {
        return EpProperties.listEp(label, runtimeName, Datatypes.Double, domainProperty);
    }

    public static EventPropertyList listStringEp(Label label, String runtimeName, String domainProperty) {
        return EpProperties.listEp(label, runtimeName, Datatypes.String, domainProperty);
    }

    public static EventPropertyList listBooleanEp(Label label, String runtimeName, String domainProperty) {
        return EpProperties.listEp(label, runtimeName, Datatypes.Boolean, domainProperty);
    }

    public static EventPropertyList listEp(Label label, String runtimeName, Datatypes runtimeType, String domainProperty) {
        return EpProperties.getPreparedProperty(label, new EventPropertyList(runtimeName, (EventProperty)EpProperties.ep(Labels.empty(), runtimeType.toString(), runtimeName, domainProperty)));
    }

    public static EventPropertyList listEp(Label label, String runtimeName, EventProperty eventProperty) {
        return EpProperties.getPreparedProperty(label, new EventPropertyList(runtimeName, eventProperty));
    }

    public static EventPropertyList listEp(Label label, String runtimeName, EventProperty eventProperty, String domainProperty) {
        return EpProperties.getPreparedProperty(label, new EventPropertyList(runtimeName, eventProperty, Utils.createURI((String[])new String[]{domainProperty})));
    }

    public static EventPropertyPrimitive booleanEp(Label label, String runtimeName, String domainProperty) {
        return EpProperties.ep(label, XSD._boolean.toString(), runtimeName, domainProperty);
    }

    public static EventPropertyPrimitive numberEp(Label label, String runtimeName, String domainProperty) {
        return EpProperties.ep(label, "http://schema.org/Number", runtimeName, domainProperty);
    }

    public static EventPropertyPrimitive stringEp(Label label, String runtimeName, String domainProperty) {
        return EpProperties.ep(label, XSD._string.toString(), runtimeName, domainProperty);
    }

    public static EventPropertyPrimitive stringEp(Label label, String runtimeName, String domainProperty, Enumeration enumeration) {
        EventPropertyPrimitive ep = EpProperties.ep(label, XSD._string.toString(), runtimeName, domainProperty);
        ep.setValueSpecification((ValueSpecification)enumeration);
        return ep;
    }

    public static EventPropertyPrimitive stringEp(Label label, String runtimeName, List<URI> domainProperties) {
        return EpProperties.ep(label, XSD._string.toString(), runtimeName, domainProperties);
    }

    public static EventPropertyPrimitive integerEp(Label label, String runtimeName, String domainProperty) {
        return EpProperties.ep(label, XSD._integer.toString(), runtimeName, domainProperty);
    }

    public static EventPropertyPrimitive integerEp(Label label, String runtimeName, List<URI> domainProperties) {
        return EpProperties.ep(label, XSD._integer.toString(), runtimeName, domainProperties);
    }

    public static EventPropertyPrimitive longEp(Label label, String runtimeName, String domainProperty) {
        return EpProperties.ep(label, XSD._long.toString(), runtimeName, domainProperty);
    }

    public static EventPropertyPrimitive longEp(Label label, String runtimeName, List<URI> domainProperties) {
        return EpProperties.ep(label, XSD._long.toString(), runtimeName, domainProperties);
    }

    public static EventPropertyPrimitive integerEp(Label label, String runtimeName, String domainProperty, Float minValue, Float maxValue, Float step) {
        return EpProperties.integerEp(label, runtimeName, domainProperty, new QuantitativeValue(minValue, maxValue, step));
    }

    public static EventPropertyPrimitive integerEp(Label label, String runtimeName, String domainProperty, QuantitativeValue valueSpecification) {
        EventPropertyPrimitive ep = EpProperties.ep(label, XSD._integer.toString(), runtimeName, domainProperty);
        ep.setValueSpecification((ValueSpecification)valueSpecification);
        return ep;
    }

    public static EventPropertyPrimitive doubleEp(Label label, String runtimeName, String domainProperty) {
        return EpProperties.ep(label, XSD._double.toString(), runtimeName, domainProperty);
    }

    public static EventPropertyPrimitive doubleEp(Label label, String runtimeName, String domainProperty, Float minValue, Float maxValue, Float step) {
        EventPropertyPrimitive ep = EpProperties.ep(label, XSD._double.toString(), runtimeName, domainProperty);
        ep.setValueSpecification((ValueSpecification)new QuantitativeValue(minValue, maxValue, step));
        return ep;
    }

    private static EventPropertyPrimitive ep(Label label, String runtimeType, String runtimeName, String domainProperty) {
        return EpProperties.getPreparedProperty(label, new EventPropertyPrimitive(runtimeType, runtimeName, "", Utils.createURI((String[])new String[]{domainProperty})));
    }

    private static EventPropertyPrimitive ep(Label label, String runtimeType, String runtimeName, List<URI> domainProperties) {
        return EpProperties.getPreparedProperty(label, new EventPropertyPrimitive(runtimeType, runtimeName, "", domainProperties));
    }

    private static <T extends EventProperty> T getPreparedProperty(Label label, T eventProperty) {
        eventProperty.setLabel(label.getLabel());
        eventProperty.setDescription(label.getDescription());
        return eventProperty;
    }
}

