/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.sdk.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.ConsumableStreamPipesEntity;
import org.streampipes.model.grounding.EventGrounding;
import org.streampipes.model.grounding.TransportFormat;
import org.streampipes.model.grounding.TransportProtocol;
import org.streampipes.model.schema.EventProperty;
import org.streampipes.model.schema.EventSchema;
import org.streampipes.model.schema.PropertyScope;
import org.streampipes.model.staticproperty.MappingProperty;
import org.streampipes.model.staticproperty.MappingPropertyNary;
import org.streampipes.model.staticproperty.MappingPropertyUnary;
import org.streampipes.model.staticproperty.RuntimeResolvableOneOfStaticProperty;
import org.streampipes.sdk.builder.AbstractConfigurablePipelineElementBuilder;
import org.streampipes.sdk.helpers.CollectedStreamRequirements;
import org.streampipes.sdk.helpers.Label;

public abstract class AbstractProcessingElementBuilder<BU extends AbstractProcessingElementBuilder<BU, T>, T extends ConsumableStreamPipesEntity>
extends AbstractConfigurablePipelineElementBuilder<BU, T> {
    protected List<SpDataStream> streamRequirements = new ArrayList<SpDataStream>();
    protected List<EventProperty> stream1Properties = new ArrayList<EventProperty>();
    protected List<EventProperty> stream2Properties = new ArrayList<EventProperty>();
    protected EventGrounding supportedGrounding = new EventGrounding();
    protected boolean stream1 = false;
    protected boolean stream2 = false;

    protected AbstractProcessingElementBuilder(String id, String label, String description, T element) {
        super(id, label, description, element);
    }

    protected AbstractProcessingElementBuilder(String id, T element) {
        super(id, element);
    }

    @Deprecated
    public BU requiredStream(SpDataStream stream) {
        this.streamRequirements.add(stream);
        return (BU)((AbstractProcessingElementBuilder)this.me());
    }

    public BU requiredStream(CollectedStreamRequirements streamRequirements) {
        this.streamRequirements.add(streamRequirements.getStreamRequirements());
        this.staticProperties.addAll(this.rewrite(streamRequirements.getMappingProperties(), this.streamRequirements.size()));
        return (BU)((AbstractProcessingElementBuilder)this.me());
    }

    private List<MappingProperty> rewrite(List<MappingProperty> mappingProperties, int index) {
        mappingProperties.stream().forEach(mp -> mp.setRequirementSelector(this.getIndex(index) + "::" + mp.getRequirementSelector()));
        return mappingProperties;
    }

    private String getIndex(int index) {
        return index == 1 ? "r0" : "r1";
    }

    public BU requiredSingleValueSelectionFromContainer(Label label) {
        RuntimeResolvableOneOfStaticProperty rsp = new RuntimeResolvableOneOfStaticProperty(label.getInternalId(), label.getLabel(), label.getDescription());
        this.staticProperties.add(rsp);
        return (BU)((AbstractProcessingElementBuilder)this.me());
    }

    public BU requiredSingleValueSelectionFromContainer(Label label, String linkedMappingPropertyId) {
        RuntimeResolvableOneOfStaticProperty rsp = new RuntimeResolvableOneOfStaticProperty(label.getInternalId(), label.getLabel(), label.getDescription());
        rsp.setLinkedMappingPropertyId(linkedMappingPropertyId);
        this.staticProperties.add(rsp);
        return (BU)((AbstractProcessingElementBuilder)this.me());
    }

    public BU naryMappingPropertyWithoutRequirement(String internalName, String label, String description) {
        this.staticProperties.add(new MappingPropertyNary(internalName, label, description));
        return (BU)((AbstractProcessingElementBuilder)this.me());
    }

    public BU naryMappingPropertyWithoutRequirement(Label label, PropertyScope propertyScope) {
        MappingPropertyNary mp = new MappingPropertyNary(label.getInternalId(), label.getLabel(), label.getDescription());
        mp.setPropertyScope(propertyScope.name());
        this.staticProperties.add(mp);
        return (BU)((AbstractProcessingElementBuilder)this.me());
    }

    public BU unaryMappingPropertyWithoutRequirement(String internalName, String label, String description) {
        this.staticProperties.add(new MappingPropertyUnary(internalName, label, description));
        return (BU)((AbstractProcessingElementBuilder)this.me());
    }

    public BU unaryMappingPropertyWithoutRequirement(Label label) {
        this.staticProperties.add(new MappingPropertyUnary(label.getInternalId(), label.getLabel(), label.getDescription()));
        return (BU)((AbstractProcessingElementBuilder)this.me());
    }

    public BU unaryMappingPropertyWithoutRequirement(Label label, PropertyScope propertyScope) {
        MappingPropertyUnary mp = new MappingPropertyUnary(label.getInternalId(), label.getLabel(), label.getDescription());
        mp.setPropertyScope(propertyScope.name());
        this.staticProperties.add(mp);
        return (BU)((AbstractProcessingElementBuilder)this.me());
    }

    public BU supportedFormats(TransportFormat ... format) {
        return this.supportedFormats(Arrays.asList(format));
    }

    public BU supportedFormats(List<TransportFormat> formats) {
        this.supportedGrounding.setTransportFormats(formats);
        return (BU)((AbstractProcessingElementBuilder)this.me());
    }

    public BU supportedProtocols(TransportProtocol ... protocol) {
        return this.supportedProtocols(Arrays.asList(protocol));
    }

    public BU supportedProtocols(List<TransportProtocol> protocols) {
        this.supportedGrounding.setTransportProtocols(protocols);
        return (BU)((AbstractProcessingElementBuilder)this.me());
    }

    public BU setStream1() {
        this.stream1 = true;
        return (BU)((AbstractProcessingElementBuilder)this.me());
    }

    public BU setStream2() {
        this.stream2 = true;
        return (BU)((AbstractProcessingElementBuilder)this.me());
    }

    @Override
    public void prepareBuild() {
        ((ConsumableStreamPipesEntity)this.elementDescription).setStaticProperties(this.getStaticProperties());
        if (this.stream1Properties.size() > 0 || this.stream1) {
            this.streamRequirements.add(this.buildStream(this.stream1Properties));
        }
        if (this.stream2Properties.size() > 0 || this.stream2) {
            this.streamRequirements.add(this.buildStream(this.stream2Properties));
        }
        ((ConsumableStreamPipesEntity)this.elementDescription).setSupportedGrounding(this.supportedGrounding);
        for (int i = 0; i < this.streamRequirements.size(); ++i) {
            this.streamRequirements.get(i).setIndex(i);
        }
        ((ConsumableStreamPipesEntity)this.elementDescription).setSpDataStreams(this.streamRequirements);
    }

    private SpDataStream buildStream(List<EventProperty> streamProperties) {
        SpDataStream stream = new SpDataStream();
        stream.setEventSchema(new EventSchema(streamProperties));
        return stream;
    }
}

